//===============================================================
// package : com.tetrasix.majix.tools
// class : com.tetrasix.majix.tools.InsertToc
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.tools;

import java.io.*;

public class InsertToc  {

	static public void main(String argv[])
	{
		String filename = argv[0];
		String tocname  = argv[1];
		
		insert(filename, tocname);
	}

	static public void insert(String filename, String tocfilename)
	{
		insert(filename, tocfilename, filename);
	}

	static public void insert(String filename, String tocfilename, String outfilename)
	{
		try {
			System.out.println("inserting " + tocfilename + " into " + filename);

			if (! filename.toLowerCase().endsWith(".html")) {
				System.out.println("Bad filename : " + filename);
				return;
			}

			FileInputStream fis;
			BufferedInputStream bis ;
			fis = new FileInputStream(filename);
			bis = new BufferedInputStream(fis);
	
			ByteArrayOutputStream baos;
			PrintWriter pw;
			baos = new ByteArrayOutputStream();
			pw = new PrintWriter(baos);

			while (true) {
				String line = read_line(bis);
				if (line == null) {
					break;
				}
				if (line.indexOf("$TOC$") >= 0) {
					print_toc(pw, filename, tocfilename);
				}
				else {
					pw.print(line);
				}
			}

			bis.close();
			fis.close();

			pw.close();

			byte bytes[] = baos.toByteArray();
			
			FileOutputStream fos = new FileOutputStream(outfilename);
			fos.write(bytes);
			fos.close();
		}
		catch(FileNotFoundException e) {
			System.out.println("file not found : ");
			System.out.println(e.getMessage());
			System.exit(3);
		}
		catch(IOException e) {
			System.out.println("IO exception : ");
			System.out.println(e.getMessage());
			System.exit(3);
		}
	}

	static String read_line(BufferedInputStream in)
	{
		StringBuffer buf = new StringBuffer();
	
		try {
			while(true) {
				int ch = in.read();
				if (ch == -1) {
					if (buf.length() == 0) {
						return null;
					}
					else {
						return buf.toString();
					}
				}
				else if ((char)ch == '\n') {
					buf.append((char)ch);
					return buf.toString();
				}
				else {
					buf.append((char)ch);
				}
			}
		}
		catch (IOException e) {
			System.out.println("IO exception : " + e.getMessage());
			return null;
		}
	}

	static void print_toc(PrintWriter out, String filename, String tocfilename)
	{
		try {
			FileInputStream fts;
			BufferedInputStream bts;
			fts = new FileInputStream(tocfilename);
			bts = new BufferedInputStream(fts);

			int pos = filename.lastIndexOf('\\');
			if (pos != -1) {
				filename = filename.substring(pos + 1);
			}

			String line;
			boolean on = false;
		
			while (true) {
				line = read_line(bts);
				if (line == null) {
					break;
				}
				else if (line.indexOf("</BODY") >= 0) {
					on = false;
				}

				if (line.indexOf(filename) >= 0) {
					int pos1 = line.indexOf("<A");
					int pos2 = line.indexOf(".html");
					int pos3 = line.indexOf("</A>");
	
					line = line.substring(0, pos1)
							+ line.substring(pos2 + 7, pos3)
							+ line.substring(pos3 + 4);
				}

				if (on) {
					out.print(line);
				}

				if (line.indexOf("<BODY") >= 0) {
					on = true;
				}
			}

			bts.close();
			fts.close();
		}
		catch(FileNotFoundException e) {
			System.out.println("file not found : ");
			System.out.println(e.getMessage());
		}
		catch (IOException e) {
			System.out.println("IO exception : " + e.getMessage());
		}
	}
}
