//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.AboutFrame
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

//import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.ResourceBundle;

import com.tetrasix.util.LogoTetraSix;
import com.tetrasix.majix.Version;
//import com.tetrasix.util.Configuration;

class AboutFrame extends JFrame implements ActionListener {

	static private AboutFrame _theFrame;
	private JButton _buttonClose;
//	private JButton _buttonRegister;

	AboutFrame()
	{
		ResourceBundle res = 
			ResourceBundle.getBundle("com.tetrasix.majix.uis.AboutFrameResources");

		setTitle(res.getString("frameTitle"));

		JPanel pc = new JPanel();
		JPanel pg = new JPanel();
		pg.setLayout(new GridLayout(3, 1, 10, 10));
		pg.add(new JLabel(Version.getVersion() + " - (" + Version.getDate() + ")"));
		pg.add(new JLabel(res.getString("line2")));
		pg.add(new JLabel(res.getString("copyright")));
		pc.add(pg);

		JPanel ps = new JPanel();
		ps.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 10));
		ps.add( _buttonClose = new JButton(res.getString("okButton")));

		_buttonClose.setActionCommand("close");
		_buttonClose.addActionListener(this);

//		ps.add( _buttonRegister = new JButton(res.getString("registerButton")));
//		_buttonRegister.setActionCommand("register");
//		_buttonRegister.addActionListener(this);

		getContentPane().add("North", new LogoTetraSix());
		getContentPane().add("Center", pc);
		getContentPane().add("South", ps);
		
		setSize(300, 350);

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		setBackground(SystemColor.control);

		center();
		show();

		_theFrame = this;
        LFlist.remove(this);
	}

	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			_theFrame = null;
            LFlist.remove(this);
			dispose();
		}
		else {
			super.processWindowEvent(e);
		}
	}

	public void actionPerformed(ActionEvent e)
	{
		String s = e.getActionCommand();

		if ("close".equals(s)) {
			_theFrame = null;
            LFlist.remove(this);
			dispose();
		}
//		else if ("register".equals(s)) {
//			register();
//		}
		else {
			System.out.println("unexpected action command : " + s);
		}
	}

	void center()
	{
		Dimension wd = getSize();
		Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();

		setLocation((sd.width - wd.width) / 2, (sd.height - wd.height) / 2);
	}

	static void showAbout()
	{
		if (_theFrame != null) {
			_theFrame.show();
		}
		else {
			new AboutFrame();
		}
	}
	
//	void register()
//	{
//		String browser = Configuration.getProperty("majix.tool.browser", "explorer.exe");
//
//		String url = "http://www.tetrasix.com/register_majix.html";
//
//		try {
//			Runtime.getRuntime().exec(browser + " " + url);
//		}
//		catch (IOException e) {
//			System.out.println("HTML browser not found");
//		}
//	}
}