//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.CheckerTextDisplay
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;

import javax.swing.JButton;

import com.tetrasix.util.CheckerSAX;
import com.tetrasix.util.Configuration;
import com.tetrasix.util.RunNSGMLS;
import com.tetrasix.util.XmlBrowser;

public class CheckerTextDisplay extends JSimpleTextDisplay {

	public CheckerTextDisplay(String filename)
	{
		super(filename);

		ResourceBundle res = 
			ResourceBundle.getBundle("com.tetrasix.majix.uis.CheckerTextDisplayResources");

		addButton(new JButton(res.getString("browse")),    "browse",   this);

		addButton(new JButton(res.getString("check_syntax")),  "checksyntax",  this);

		addButton(new JButton(res.getString("apply_xsl")), "applyxsl", this);
	}

	public void actionPerformed(ActionEvent  e)
	{
		String s = e.getActionCommand();

		if ("checksyntax".equals(s)) {

			if (Configuration.getProperty("majix.check.default").equals("nsgmls")) {
				RunNSGMLS.check(getFileName(), this);
			}
			else {
				long startTime = System.currentTimeMillis();
				CheckerSAX.check(getFileName(), this);
			}
		}
		else if ("applyxsl".equals(s)) {
			new ShellXT(this, getFileName());
		}
		else if ("browse".equals(s)) {
			XmlBrowser.browse(getFileName());
		}
		else {
			super.actionPerformed(e);
		}
	}
}