//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.ExtensionFilenameFilter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.io.FilenameFilter;
import java.io.File;

public class ExtensionFilenameFilter implements FilenameFilter
{
	String _ext[];

	public ExtensionFilenameFilter(String extension)
	{
		_ext = new String[1];
		_ext[0] = extension.toUpperCase();
	}

	public ExtensionFilenameFilter(String extension1, String extension2)
	{
		_ext = new String[2];
		_ext[0] = extension1.toUpperCase();
		_ext[1] = extension2.toUpperCase();
	}

	public boolean accept(File dir, String  name)
	{
		for (int ii = 0; ii < _ext.length; ii++) {
			if (name.toUpperCase().endsWith(_ext[ii])) {
				return true;
			}
		}
		return false;
	}
}

