//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.InteractiveAbstractStyleProvider
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.tetrasix.majix.rtf.AbstractStyleProvider;
import com.tetrasix.majix.rtf.AbstractTranslator;
import com.tetrasix.majix.rtf.RtfAbstractStylesheet;
import com.tetrasix.majix.rtf.RtfStyleMap;

public class InteractiveAbstractStyleProvider
	 implements AbstractStyleProvider {

	public Frame _owner;
	private String _reply;
	private RtfStyleMap _map;
	ResourceBundle _res = null;

	public InteractiveAbstractStyleProvider(Frame owner)
	{
		_owner = owner;
		_res = ResourceBundle.getBundle("com.tetrasix.majix.uis.InteractiveAbstractStyleProviderResources");

	}

	public String lookup(RtfStyleMap map, String ename, boolean paragraphstyle)
	{
		_map = map;
		String ret = doit(ename, paragraphstyle);
		_map = null;
		return ret;
	}

	synchronized private String doit(String ename, boolean paragraphstyle)
	{
		//ProviderFrameThread t = new ProviderFrameThread(ename, this);
		//t.start();


		new ProviderFrame(ename, this, paragraphstyle);
		try {
			wait();
		}
		catch (InterruptedException e) {
		}

		if (_reply != null) {
			if (paragraphstyle) {
				_map.defineParagraph(ename, _reply, false);
			}
			else {
				_map.defineCharacter(ename, _reply, false);
			}

			return _reply;
		}
		else {
			if (paragraphstyle) {
				return "p";
			}
			else {
				return "cs";
			}
		}
	}

	synchronized private void release()
	{
		notify();
	}

	class ProviderFrame 
		extends Frame implements ActionListener
	{
		private String _ename;
		private InteractiveAbstractStyleProvider _lock;
		private Choice _choice;

		ProviderFrame(String ename, InteractiveAbstractStyleProvider lock, boolean paragraphstyle)
		{
			_ename = ename;
			_lock = lock;

			setSize(300, 300);
			
			enableEvents(AWTEvent.WINDOW_EVENT_MASK);
			build(paragraphstyle);
			center();
			show();
		}

		void build(boolean paragraphstyle)
		{
			setTitle(_res.getString("frameTitle"));

			Label label1 = new Label(_res.getString("rtf_style_label") + _ename);

			Panel pchoice = new Panel();
			pchoice.setLayout(new FlowLayout(FlowLayout.LEFT, 10, 10));
			pchoice.add(new Label(_res.getString("abstract_style_label")));
			_choice = new Choice();
			pchoice.add(_choice);

			if (paragraphstyle) {
				LoadChoiceParagraph();
			}
			else {
				LoadChoiceCharacter();
			}
			
			Panel pbuttons = new Panel();
			pbuttons.setLayout(new FlowLayout(FlowLayout.CENTER, 10, 10));

			Button cancelButton = new Button(_res.getString("cancel_button"));
			cancelButton.addActionListener(this);
			cancelButton.setActionCommand("cancel");
			pbuttons.add(cancelButton);

			Button okButton = new Button(_res.getString("ok_button"));
			okButton.addActionListener(this);
			okButton.setActionCommand("ok");
			pbuttons.add(okButton);
			
			add("North", label1);
			add("Center", pchoice);
			add("South", pbuttons);

			setBackground(SystemColor.control);
		}

	  	private void LoadChoiceParagraph()
		{
			RtfAbstractStylesheet assheet = _map.getAbstractStyleSheet();
			for  (Enumeration  e  =  assheet.getParagraphStyleNames()  ;
					e.hasMoreElements() ;) {

				String item = e.nextElement().toString();
				_choice.addItem(translate(assheet.getDescription(item)));
			}

			_choice.select(translate(assheet.getDescription(assheet.getDefaultStyle())));
		}

	  	private void LoadChoiceCharacter()
		{
			RtfAbstractStylesheet assheet = _map.getAbstractStyleSheet();
			for  (Enumeration  e  =  assheet.getCharacterStyleNames()  ;
					e.hasMoreElements() ;) {

				String item = e.nextElement().toString();
				_choice.addItem(translate(assheet.getDescription(item)));
			}

			_choice.select(translate(assheet.getDescription(assheet.getDefaultStyle())));
		}

		protected void processWindowEvent(WindowEvent e)
		{
			if (e.getID() == WindowEvent.WINDOW_CLOSING) {
				setVisible(false);
				dispose();
			}
			else {
				super.processWindowEvent(e);
			}
		}

		public void actionPerformed(ActionEvent e)
		{
			String s = e.getActionCommand();

			boolean ret = true;

			if ("ok".equals(s)) {
				String desc = _choice.getSelectedItem();
				RtfAbstractStylesheet assheet = _map.getAbstractStyleSheet();
				_reply = assheet.getNameFromDescription(desc, new AbstractStyleTranslator());
				_lock.release();
				setVisible(false);
				dispose();
			}
			else if ("cancel".equals(s)) {
				_reply = null;
				_lock.release();
				setVisible(false);
				dispose();
			}
		}

		void center()
		{
			Dimension wd = getSize();
			Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();

			setLocation((sd.width - wd.width) / 2, (sd.height - wd.height) / 2);
		}
	}

	private String translate(String name)
	{
		String ret;

		try {
			ret = _res.getString(name);
		}
		catch (MissingResourceException e) {
			ret = name;
		}

		return ret;
	}

	class AbstractStyleTranslator 
			implements AbstractTranslator {

		public String doit(String arg)
		{
			return translate(arg);
		}
	}
}
