//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.JFlexibleList
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package  com.tetrasix.majix.uis;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;

import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class JFlexibleList implements MouseListener {
	
	private DefaultListModel _objects;
	private JList _list;
    private JScrollPane _scrollPane;
	private Object _context;
	private int _rows;

	private JEditableListElement _elem;

    public JFlexibleList(int rows, Object context)
    {
        _context = context;
        _objects = new DefaultListModel();
        _list = new JList(_objects);
        _list.setPrototypeCellValue(new DefaultEditableListElement("1234567890123456789012345"));
        _list.addMouseListener(this);
        _list.setCellRenderer(new DefaultListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                                              Object value,
                                              int index,
                                              boolean isSelected,
                                              boolean cellHasFocus)            
            {
                return super.getListCellRendererComponent(list,
                                              ((JEditableListElement)value).description(),
                                              index,
                                              isSelected,
                                              cellHasFocus);
            }
        });
        _scrollPane = new JScrollPane(_list);
    }
    
    public JFlexibleList(int rows, Object context, int width)
    {
        _context = context;
        _objects = new DefaultListModel();
        _list = new JList(_objects);
        _list.setFixedCellWidth(width);
        _list.addMouseListener(this);
        _list.setCellRenderer(new DefaultListCellRenderer() {
            public Component getListCellRendererComponent(JList list,
                                              Object value,
                                              int index,
                                              boolean isSelected,
                                              boolean cellHasFocus)            
            {
                return super.getListCellRendererComponent(list,
                                              ((JEditableListElement)value).description(),
                                              index,
                                              isSelected,
                                              cellHasFocus);
            }
        });
        _scrollPane = new JScrollPane(_list);
    }
    
    public void setPrototype(String value)
    {
        _list.setPrototypeCellValue(new DefaultEditableListElement(value));
    }

	public void addItem(JEditableListElement obj)
	{
		_objects.addElement(obj);
		obj.setOwner(this);
	}

	public Component getComponent()
	{
		return _scrollPane;
	}

	public void editSelection()
	{
		if (_elem != null) {
			cancelEditList();
		}

		int sel = _list.getSelectedIndex();
		if (sel >= 0) {
			_elem = (JEditableListElement) _objects.elementAt(sel);
			_elem.startEdit(_context);
		}

	}

	public void validateEditList()
	{
		if (_elem != null) {
			_elem.validateEdit(_context);
            refresh();
		}
	}

	public void cancelEditList()
	{
		if (_elem != null) {
			_elem.cancelEdit(_context);
			_elem = null;
		}
	}

	public void removeAll()
	{
		_objects.clear();
	}

	public Enumeration getElements()
	{
		return _objects.elements();
	}

    public void mouseClicked(MouseEvent evt)
    {
        if (    ((evt.getModifiers() & MouseEvent.BUTTON1_MASK) != 0)
             && (evt.getClickCount() == 2) ) {
                 
            editSelection();
        }
    }
    
    public void mousePressed(MouseEvent evt)
    {
    }
    
    public void mouseEntered(MouseEvent evt)
    {
    }
    
    public void mouseExited(MouseEvent evt)
    {
    }
    
    public void mouseReleased(MouseEvent evt)
    {
    }
    
    public void refresh()
    {
        int selected = _list.getSelectedIndex();

        for (int ii = 0; ii < _objects.size(); ii++) {
            JEditableListElement obj = (JEditableListElement) _objects.elementAt(ii);
            if (obj.isChanged()) {
                _objects.setElementAt(obj, ii);
                obj.setChanged(false);
            }
        }
    }
}