//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.SimpleTextDisplay
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.util.ResourceBundle;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.tetrasix.util.MessageBox;

public class JSimpleTextDisplay extends JFrame implements ActionListener
{
	private JPanel          _buttonsPanel;
	private String		   _filename;
	private ResourceBundle _res;
		
	public JSimpleTextDisplay(String title, String text)
	{
		ResourceBundle _res = 
			ResourceBundle.getBundle("com.tetrasix.util.SimpleTextDisplayResources");

		setTitle(title);

		getContentPane().setLayout(new BorderLayout(0, 0));

		setSize(500, 400);

		getContentPane().add("Center", new JScrollPane(new JTextArea(text)));

		_buttonsPanel = new JPanel();

		addButton(new JButton(_res.getString("close_button")), "close", this);

		getContentPane().add("South", _buttonsPanel);

		_filename = "";
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	}

	public JSimpleTextDisplay(String filename)
	{
		ResourceBundle _res = 
			ResourceBundle.getBundle("com.tetrasix.util.SimpleTextDisplayResources");

		setTitle(_res.getString("frameTitlePrefix") + " " + filename);

		_filename = filename;

		getContentPane().setLayout(new BorderLayout(0, 0));

		setSize(500, 400);

		FileInputStream fis;
		try {
			fis = new FileInputStream(filename);
		}
		catch (FileNotFoundException e) {
			Message("File not found : " + filename);
			return;
		}

		String text;
		try {
			int size = fis.available();
			byte b[] = new byte[size];
			fis.read(b);
			text = new String(b);
			fis.close();
		}
		catch (FileNotFoundException e) {
			Message("File not found : " + filename);
			return;
		}
		catch (IOException e) {
			Message("IO exception : " + filename);
			return;
		}

		getContentPane().add("Center", new JScrollPane(new JTextArea(text)));

		_buttonsPanel = new JPanel();

		addButton(new JButton(_res.getString("close_button")), "close", this);

		getContentPane().add("South", _buttonsPanel);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	}

	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			setVisible(false);
			dispose();
		}
		else {
			super.processWindowEvent(e);
		}
	}

	public void actionPerformed(ActionEvent  e)
	{
		String s = e.getActionCommand();

		if ("close".equals(s)) {
			dispose();
		}
	}

	protected void addButton(JButton button, String command, ActionListener listener)
	{
		button.addActionListener(listener);
		button.setActionCommand(command);
		_buttonsPanel.add(button);
	}

	public void Message(String msg)
	{
		new MessageBox(this, msg);
	}

	public void setVisible()
	{
		addNotify();
		setLocation(100, 100);

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		
		setBackground(SystemColor.control);

		super.setVisible(true);
	}

	public String getFileName()
	{
		return _filename;
	}

}