//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.ShowHelp
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package com.tetrasix.majix.uis;

import java.io.*;
import java.util.ResourceBundle;

import com.tetrasix.util.*;

public class ShowHelp {

	public static void load(String topic)
	{
		ResourceBundle res = 
			ResourceBundle.getBundle("com.tetrasix.majix.uis.ShowHelpResources");

		String browser = Configuration.getProperty("majix.tool.browser", "explorer.exe");

		String filesep = System.getProperty("file.separator");
		String userdir = System.getProperty("user.dir");
		String majixdoc = Configuration.getProperty("majix.dir.doc");
		String path = "";

		if (majixdoc == null) {
			majixdoc = userdir + filesep + "docs";
		}

		String url = majixdoc + filesep + res.getString(topic);

		try {
			Runtime.getRuntime().exec(browser + " " + url);
		}
		catch (IOException e) {
			System.out.println("HTML browser not found");
		}
	}
}