//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.ToolsFrame
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

import com.tetrasix.util.Configuration;

public class ToolsFrame 
	extends JFrame 
	implements ActionListener, MouseListener {

	private JFrame _owner;

	private JButton _closeButton;
	private JButton _helpButton;
	private JButton _runButton;
	private JList   _toolsList;

	ResourceBundle _res;

	private static final String _HELP_TOPIC = "tools_frame";
	private static final int _DEFAULT_WIDTH = 300;
	private static final int _DEFAULT_HEIGHT = 200;


	private static final String _TOOLS_CONFIG   = "edit_config";
	private static final String _TOOLS_XP       = "check_xp";
	private static final String _TOOLS_SP       = "check_sp";
	private static final String _TOOLS_XT       = "run_xt";
	private static final String _TOOLS_SPLITTER = "run_splitter";

	public ToolsFrame(JFrame owner)
	{
		_res = ResourceBundle.getBundle("com.tetrasix.majix.uis.ToolsFrameResources");

		setTitle(_res.getString("frame_title"));

		_owner = owner;
        LFlist.add(this);

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

		build();
	}
	
	public void Run()
	{
		setSize(_DEFAULT_WIDTH, _DEFAULT_HEIGHT);
		center();
		show();
	}

	private void build()
	{
		Vector v = new Vector();
		//_toolsList.addListSelectionListener(this);
		//_toolsList.addActionListener(this);
		//@@@ utiliser un MouseListener

		v.addElement(_res.getString(_TOOLS_CONFIG));
		v.addElement(_res.getString(_TOOLS_XP));

		if (Configuration.getProperty("majix.enable.nsgmls").equals("1")) {
			v.addElement(_res.getString(_TOOLS_SP));
		}

		v.addElement(_res.getString(_TOOLS_XT));
		v.addElement(_res.getString(_TOOLS_SPLITTER));

		_toolsList = new JList(v);
		_toolsList.addMouseListener(this);

		JPanel pbutton = new JPanel();

		if (Configuration.getProperty("majix.enable.doc").equals("1")) {
			pbutton.add( _helpButton = new JButton(_res.getString("help_button")));
			_helpButton.setActionCommand("help");
			_helpButton.addActionListener(this);
		}

		pbutton.add( _runButton = new JButton(_res.getString("run_button")));
		_runButton.setActionCommand("run");
		_runButton.addActionListener(this);

		pbutton.add( _closeButton = new JButton(_res.getString("close_button")));
		_closeButton.setActionCommand("close");
		_closeButton.addActionListener(this);

		JLabel listLabel = new JLabel(_res.getString("list_label"));

		getContentPane().add("North", listLabel);
		getContentPane().add("Center", _toolsList);
		getContentPane().add("South", pbutton);

		setBackground(SystemColor.control);
	}

	void center()
	{
		Dimension wd = getSize();
		Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();

		setLocation((sd.width - wd.width) / 2, (sd.height - wd.height) / 2);
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() instanceof JButton) {
			String s = e.getActionCommand();
	
			if (s.equals("close")) {
				setVisible(false);
                LFlist.remove(this);
				dispose();
			}
			else if (s.equals("help")) {
				showHelp();
			}
			else if (s.equals("run")) {
				RunTool();
			}
			else {
				System.out.println("unexpected action command : " + s);
			}
		}
	}

	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			setVisible(false);
            LFlist.remove(this);
			dispose();
		}
		else {
			super.processWindowEvent(e);
		}
	}
	
	public void mouseClicked(MouseEvent evt)
	{
        if (    ((evt.getModifiers() & MouseEvent.BUTTON1_MASK) != 0)
             && (evt.getClickCount() == 2) ) {
            RunTool();
        }
	}
	
	public void mousePressed(MouseEvent evt)
	{
	}
	
	public void mouseEntered(MouseEvent evt)
	{
	}
	
	public void mouseExited(MouseEvent evt)
	{
	}
	
	public void mouseReleased(MouseEvent evt)
	{
	}
	
	private void showHelp()
	{
		ShowHelp.load(_HELP_TOPIC);
	}

	private void RunTool()
	{
		String label = (String) _toolsList.getSelectedValue();
		if (label != null) {
			if (label.equals(_res.getString(_TOOLS_CONFIG))) {
				RunConfigEditor();
			}
			else if (label.equals(_res.getString(_TOOLS_XP))) {
				RunXP();
			}
			else if (label.equals(_res.getString(_TOOLS_SP))) {
				RunSP();
			}
			else if (label.equals(_res.getString(_TOOLS_XT))) {
				RunXT();
			}
			else if (label.equals(_res.getString(_TOOLS_SPLITTER))) {
				RunSplitter();
			}
			else {
				System.out.println("Unknown tool : " + label);
			}
		}
	}
	
	public void RunConfigEditor()
	{
		new ConfigEditor(this, true);
	}

	private void RunXP()
	{
		new ShellXP(this);
	}

	private void RunSP()
	{
		new ShellSP(this);
	}

	private void RunXT()
	{
		new ShellXT(this);
	}

	private void RunSplitter()
	{
		new ShellSplitter(this);
	}
}