//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.xml.Converter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================

/**
 * @version 1.1
 */

package com.tetrasix.majix.xml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Date;

import com.tetrasix.majix.MajixBatch;
import com.tetrasix.majix.rtf.RtfAnalyser;
import com.tetrasix.majix.rtf.RtfDocument;
import com.tetrasix.majix.rtf.RtfReader;
import com.tetrasix.util.FilePathUtility;
import com.tetrasix.util.MessageSink;

public class Converter {

    static public boolean Convert(ConversionTemplate template,
            String inputfile, String outputfile, boolean dump, boolean debug,
            MessageSink msgsink) {
        long conversionStart = System.currentTimeMillis();
        try {
            boolean must_delete = false;
            String rtfinputfile = inputfile;

//            if (inputfile.toLowerCase().endsWith(".doc")) {
//
//                rtfinputfile = inputfile.substring(0, inputfile.length() - 4)
//                        + ".rtf";
//
//                System.out.println("doc file is " + inputfile);
//                System.out.println("rtf file is " + rtfinputfile);
//
//                String op = "";
//                try {
//
//                    ActiveXComponent app = new ActiveXComponent(
//                            "Word.Application");
//                    app.setProperty("Visible", new Variant(true));
//
//                    op = "Documents";
//                    Object documents = app.getProperty("Documents")
//                            .toDispatch();
//
//                    op = "Open";
//                    Object document = Dispatch.invoke(
//                            documents,
//                            "Open",
//                            Dispatch.Method,
//                            new Object[] { inputfile, new Variant(false),
//                                    new Variant(true)}, new int[1])
//                            .toDispatch();
//
//                    op = "SaveAs";
//                    Dispatch.invoke(document, "SaveAs", Dispatch.Method,
//                            new Object[] { rtfinputfile, new Integer(6)},
//                            new int[1]);
//
//                    op = "Close";
//                    Dispatch.invoke(document, "Close", Dispatch.Method,
//                            new Object[] { new Variant(0)}, new int[1]);
//
//                    op = "Quit";
//                    Dispatch.invoke(app.getObject(), "Quit", Dispatch.Method,
//                            new Object[] { new Variant(-2)}, new int[1]);
//                } catch (Exception e) {
//                    System.out
//                            .println("Unexpected exception when executing operation "
//                                    + op);
//                    System.out.println("message is " + e.getMessage());
//                    e.printStackTrace();
//                    return false;
//                }
//
//                if (rtfinputfile == null) {
//                    System.out.println("Unable to convert into RTF : "
//                            + inputfile);
//                    return false;
//                } else {
//                    must_delete = true;
//                }
//            }

            RtfReader reader;
            try {
                reader = new RtfReader(rtfinputfile);
            } catch (FileNotFoundException e) {
                System.err.println("File not found : " + inputfile);
                return false;
            }

            FileOutputStream fos;
            fos = new FileOutputStream(outputfile);

            BufferedOutputStream bos = new BufferedOutputStream(fos);
            //PrintWriter pw = new PrintWriter(bos);
            XmlWriter xw = new XmlWriter(bos);

            if (msgsink != null) {
                msgsink.MessageUsingResource("status_parsing_rtf");
            }

            RtfAnalyser ana = new RtfAnalyser(reader, xw);
            RtfDocument doc = ana.parse();

            String is_xml = template.getGeneratorParam().getAttributes("ix");

            XmlGeneratorParam param = template.getGeneratorParam();

            if ((is_xml != null) && is_xml.equals("true")) {
                String pi = "<?xml version=\"1.0\"";
                String encoding = param.getActualTag("ec", true);
                if (!encoding.equals("")) {
                    pi = pi + " encoding=\"" + encoding + "\"";
                }
                String standalone = param.getActualTag("sa", true);
                if (!standalone.equals("")) {
                    if (standalone.equals("true")) {
                        pi = pi + " standalone=\"yes\"";
                    } else {
                        pi = pi + " standalone=\"no\"";
                    }
                }
                pi = pi + "?>";
                xw.println(pi);
            }
            if (!param.getActualTag("sn", true).equals("")
                    && !param.getActualTag("st", true).equals("")) {

                xw.println("<?xml:stylesheet type=\""
                        + param.getActualTag("st", true) + "\" href=\""
                        + param.getActualTag("sn", true) + "\"?>");
            }
            
			if (!MajixBatch.styleSheetCall) {
	            xw.println("<!-- generated by Majix from " + inputfile + " on "
	                    + new Date() + " using template " + template.getName()
	                    + " -->");
			}

            if (dump) {
                xw.println("<!-- dump of the DOCRTF intermediate structure");
                doc.Dump(xw);
                xw.println("-->");
            }

            if (msgsink != null) {
                msgsink.MessageUsingResource("status_generating_xml");
            }

            XmlGenerator gen = new XmlGenerator(template);

            gen.reset();
            gen.setDebugFlag(debug);
            gen.setDirectory(FilePathUtility.getDirectory(outputfile));
            gen.setFileName(FilePathUtility.getFileName(outputfile));
            gen.generate(doc, xw, null);

            xw.flush();
            xw.close();

            reader.close();

            if (must_delete) {
                if (!(new File(rtfinputfile).delete())) {
                    System.err.println("Unable to delete file " + rtfinputfile);
                }
            }
long conversionTime = System.currentTimeMillis()-conversionStart;
//System.out.println("Conversion time: "+conversionTime+" ms");
            return true;
        } catch (Throwable e) {
long conversionTime = System.currentTimeMillis()-conversionStart;
//System.out.println("Conversion time: "+conversionTime+" ms");
            System.err.println("An exception occurred : " + e.toString());
            e.printStackTrace();
            return false;
        }
    }
}