//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlGeneratorAutomaton
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import com.jclark.xml.output.XMLWriter;

public class XmlGeneratorAutomaton {

	private ConversionTemplate     _template;
	private XmlGeneratorState      _start = null;
	private XmlGeneratorState      _start_cell = null;
	private XmlGeneratorTransition _default_transition = null;

	private Vector _transitions = new Vector(100);

	public XmlGeneratorAutomaton(ConversionTemplate template)
	{
		_template = template;
	}


	public XmlGeneratorTransition defineTransition(XmlGeneratorState startState,
						  XmlGeneratorState endState,
						  String key,
						  String generate_before,
						  boolean generate_paragraph,
						  String generate_after,
						  boolean again,
						  boolean push)
	{
		return
			defineTransition(startState,
							 endState,
							 key,
							 XmlTagTemplate.parse(_template, generate_before),
							 generate_paragraph,
							 XmlTagTemplate.parse(_template, generate_after),
							 again,
							 push);
	}

	public XmlGeneratorTransition defineTransition(XmlGeneratorState startState,
						  XmlGeneratorState endState,
						  String key,
						  XmlTagTemplate generate_before,
						  boolean generate_paragraph,
						  XmlTagTemplate generate_after,
						  boolean again,
						  boolean push)
	{
		XmlGeneratorTransition transition
			= new XmlGeneratorTransition(endState, generate_before, generate_paragraph, generate_after, again, push);
		if (startState != null) {
			startState.setTransition(key, transition);
		}
		_transitions.addElement(transition);

		return transition;
	}

	public XmlGeneratorTransition defineDefaultTransition(XmlGeneratorState endState,
								 XmlTagTemplate generate_before,
								 boolean generate_paragraph,
								 XmlTagTemplate generate_after)
	{
		XmlGeneratorTransition transition
			= new XmlGeneratorTransition(endState, generate_before, generate_paragraph, generate_after, true, false);
		_default_transition = transition;

		return transition;
	}


	public void setStartState(XmlGeneratorState state)
	{
		_start = state;
	}

	public void setStartCellState(XmlGeneratorState state)
	{
		_start_cell = state;
	}

	public XmlGeneratorState getStartState()
	{
		return _start;
	}

	public XmlGeneratorState getStartCellState()
	{
		return _start_cell;
	}

	public XmlGeneratorTransition getDefaultTransition()
	{
		return _default_transition;
	}

	public void save(XMLWriter writer) throws IOException
	{
		writer.write("\n");
		writer.comment("the automaton contains " + _transitions.size() + " transitions");
		writer.write("\n");
		writer.startElement("automaton");
		if (_start != null) {
			writer.attribute("start", _start.getName());
		}
		if (_start_cell != null) {
			writer.attribute("startcell", _start_cell.getName());
		}

		for (Enumeration e = _transitions.elements(); e.hasMoreElements(); ) {
			XmlGeneratorTransition tr = (XmlGeneratorTransition) e.nextElement();

			tr.save(writer);
		}


		if (_default_transition != null) {
			writer.write("\n");
			writer.startElement("default");
			_default_transition.save(writer);
			writer.write("\n");
			writer.endElement("default");
		}

		writer.write("\n");
		writer.endElement("automaton");
	}
}


 