//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlGeneratorState
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.util.Hashtable;

public class XmlGeneratorState {

	private Hashtable _transitions = new Hashtable();
	private XmlGeneratorTransition _default_transition;
	private String _name;

	public XmlGeneratorState(String name)
	{
		_name = name;
	}

	public void setTransition(String key, XmlGeneratorTransition transition)
	{
		if (key == null) {
			_default_transition = transition;
		}
		else {
			_transitions.put(key, transition);
		}
		transition.setStartState(this);
		transition.setKey(key);
	}

	public XmlGeneratorTransition next(String key)
	{
		XmlGeneratorTransition  transition = (XmlGeneratorTransition) _transitions.get(key);
		if (transition == null) {
			transition = (XmlGeneratorTransition) _transitions.get("*EMPTY*");
		}

		return transition;
	}

	public String getName()
	{
		return _name;
	}

	public XmlGeneratorTransition getDefaultTransition()
	{
		return _default_transition;
	}

	public String toString()
	{
		return _name;
	}
}

