//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlGeneratorStateStack
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;


class XmlGeneratorStateStack {

	XmlGeneratorStateStackCell _top;

	XmlGeneratorStateStack()
	{
		_top = null;
	}

	void push(XmlGeneratorState state)
	{
		_top = new XmlGeneratorStateStackCell(_top, state);
	}

	XmlGeneratorState pop()
	{
		XmlGeneratorStateStackCell save = _top;

		if (_top != null) {
			_top = _top.getNextCell();
		}

		if (save != null) {
			return save.getState();
		}
		else {
			return null;
		}
	}

	boolean empty()
	{
		return _top == null;
	}

	XmlGeneratorState top()
	{
		if (_top != null) {
			return _top.getState();
		}
		else {
			return null;
		}
	}

	public String toString()
	{
		StringBuffer buf = new StringBuffer();
		XmlGeneratorStateStackCell cell = _top;

		while (cell != null) {
			buf.append(cell.toString());
			buf.append(" ");
			cell = cell.getNextCell();
		}

		return buf.toString();
	}

}


class XmlGeneratorStateStackCell {

	private XmlGeneratorState _state;
	private XmlGeneratorStateStackCell _nextcell;

	XmlGeneratorStateStackCell(XmlGeneratorStateStackCell cell, XmlGeneratorState state)
	{
		_state = state;
		_nextcell = cell;
	}

	XmlGeneratorStateStackCell getNextCell()
	{
		return _nextcell;
	}

	XmlGeneratorState getState()
	{
		return _state;
	}

	public String toString()
	{
		return _state.toString();
	}
}

