//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlGeneratorTransition
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.*;

import com.jclark.xml.output.XMLWriter;

public class XmlGeneratorTransition {

	private XmlGeneratorState _startstate;
	private XmlGeneratorState _endstate;
	private XmlTagTemplate	  _generate_before;
	private boolean			  _generate_paragraph;
	private XmlTagTemplate	  _generate_after;
	private boolean			  _again;
	private boolean			  _push;
	private String            _key;

	XmlGeneratorTransition(XmlGeneratorState endstate,
						   XmlTagTemplate generate_before,
						   boolean generate_paragraph,
						   XmlTagTemplate generate_after,
						   boolean again,
						   boolean push)
	{
		_startstate          = null;
		_endstate            = endstate;
		_generate_before     = generate_before;
		_generate_paragraph  = generate_paragraph;
		_generate_after      = generate_after;
		_again               = again;
		_push                = push;
		_key                 = null;
	}

	void setStartState(XmlGeneratorState state)
	{
		_startstate = state;
	}

	void setKey(String key)
	{
		_key = key;
	}

	XmlGeneratorState getStartState()
	{
		return _startstate;
	}

	XmlGeneratorState getEndState()
	{
		return _endstate;
	}

	XmlTagTemplate getGenerateBefore()
	{
		return _generate_before;
	}

	XmlTagTemplate getGenerateAfter()
	{
		return _generate_after;
	}

	boolean getGenerateParagraphFlag()
	{
		return _generate_paragraph;
	}

	boolean getAgainFlag()
	{
		return _again;
	}

	boolean getPushFlag()
	{
		return _push;
	}

	public void setGenerateBefore(XmlTagTemplate tt)
	{
		_generate_before = tt;
	}

	public void setGenerateAfter(XmlTagTemplate tt)
	{
		_generate_after = tt;
	}

	void save(XMLWriter writer) throws IOException
	{
		writer.write("\n");
		writer.startElement("transition");
		XmlGeneratorState startState = getStartState();
		if (startState != null) {
			writer.attribute("start", startState.getName());
		}
		if (_key != null) {
			writer.attribute("key", _key);
		}
		XmlGeneratorState endState = getEndState();
		if (endState != null) {
			writer.attribute("end", endState.getName());
		}

		if (_generate_paragraph) {
			writer.attribute("generate_paragraph", "1");
		}
		if (_again) {
			writer.attribute("again", "1");
		}
		if (_push) {
			writer.attribute("push", "1");
		}

		writer.write("\n  ");
		writer.startElement("before");
		if (_generate_before != null) {
			_generate_before.save(writer);
		}
		writer.write("\n  ");
		writer.endElement("before");

		writer.write("\n  ");
		writer.startElement("after");
		if (_generate_after != null) {
			_generate_after.save(writer);
		}

		writer.write("\n  ");
		writer.endElement("after");

		writer.write("\n");
		writer.endElement("transition");
	}
}


