//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlTagTemplateElement
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.IOException;

import com.jclark.xml.output.XMLWriter;

public class XmlTagTemplateElement extends XmlTagTemplate {

	ConversionTemplate _template;
	private boolean _endtag;
	private String _tag;

	public XmlTagTemplateElement(ConversionTemplate template, String tag, boolean endtag)
	{
		_template = template;
		_endtag = endtag;
		_tag = tag;
	}

	public boolean isStartTag()
	{
		return ! _endtag;
	}

	public String toString(XmlGeneratorFunctor functor)
	{
		String ident = "";
		if ((! _endtag) && (_identifiers != null)) {
			ident = " " + _template.getGeneratorParam().getAttributes("id")
				+ "='" + _identifiers.getData() + "'";
		}
		String actualtag = _template.getGeneratorParam().getActualTag(_tag, ! _endtag);
		boolean special = _template.getGeneratorParam().getSpecial(_tag);
		String sspecial = "";
		if (special && (functor != null)) {
			sspecial = functor.doit(_tag);
		}


		if ((actualtag != null) && (actualtag.length() > 0)) {
			// quick hack deleting attributes in end tag
			return "<" + (_endtag ? "/" : "") + actualtag + (_endtag ? ">" : ident + sspecial + ">");
		}
		else {
			return "";
		}
	}

	public String toString()
	{
		return toString(null);
	}

	void save(XMLWriter writer) throws IOException
	{
		writer.write("\n    ");
		writer.startElement("tt_element");
		writer.attribute("tag", _tag);
		if (_endtag) {
			writer.attribute("endtag", "1");
		}
		writer.endElement("tt_element");
	}
}

