//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlTagTemplateList
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

import com.jclark.xml.output.XMLWriter;


public class XmlTagTemplateList extends XmlTagTemplate {

	private Vector _content;

	public XmlTagTemplateList()
	{
		_content = new Vector();
	}

	public void add(XmlTagTemplate template)
	{
		_content.addElement(template);
	}

	public String toString()
	{
		return toString(null);
	}

	public String toString(XmlGeneratorFunctor functor)
	{
		StringBuffer buf = new StringBuffer();

		boolean first = true;
		for  (Enumeration e = _content.elements(); e.hasMoreElements() ;) {
			XmlTagTemplate elem = (XmlTagTemplate) e.nextElement();
			if (first && (elem instanceof XmlTagTemplateElement)) {
				XmlTagTemplateElement templ = (XmlTagTemplateElement) elem;
				if (templ.isStartTag()) {
					templ.setIdentifiers(getIdentifiers());
					first = false;
				}
			}
			buf.append(elem.toString(functor));
		}

		return buf.toString();
	}

	void save(XMLWriter writer) throws IOException
	{
		writer.write("\n    ");
		writer.startElement("tt_list");
		for  (Enumeration e = _content.elements(); e.hasMoreElements() ;) {
			XmlTagTemplate elem = (XmlTagTemplate) e.nextElement();
			elem.save(writer);
		}
		writer.endElement("tt_list");
	}
}

