//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.Alerter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.util;

import java.awt.*;

public class Alerter {

	private static Frame _frame;

	public static void initInteractive(Frame frame)
	{
		_frame = frame;
	}

	public static void initBatch()
	{
		_frame = null;
	}

	public static void signal(String msg)
	{
		if (_frame != null) {
			new MessageBox(_frame, msg);
		}
		else {
			System.out.println(msg);
		}
	}

	public static void signal(String msg, String title)
	{
		if (_frame != null) {
			new MessageBox(_frame, msg, title);
		}
		else {
			System.out.println(msg);
		}
	}

	public static void signal(Frame frame, String msg)
	{
		if (frame != null) {
			new MessageBox(frame, msg);
		}
		else {
			System.out.println(msg);
		}
	}

	public static void signal(Frame frame, String msg, String title)
	{
		if (frame != null) {
			new MessageBox(frame, msg, title);
		}
		else {
			System.out.println(msg);
		}
	}

	public static void signal(String msg[])
	{
		if (_frame != null) {
			new MessageBox(_frame, msg);
		}
		else {
			for (int ii = 0; ii < msg.length; ii++) {
				System.out.println(msg[ii]);
			}
		}
	}

	public static void signal(String msg[], String title)
	{
		if (_frame != null) {
			new MessageBox(_frame, msg, title);
		}
		else {
			for (int ii = 0; ii < msg.length; ii++) {
				System.out.println(msg[ii]);
			}
		}
	}

	public static void signal(Frame frame, String msg[])
	{
		if (frame != null) {
			new MessageBox(frame, msg);
		}
		else {
			for (int ii = 0; ii < msg.length; ii++) {
				System.out.println(msg[ii]);
			}
		}
	}

	public static void signal(Frame frame, String msg[], String title)
	{
		if (frame != null) {
			new MessageBox(frame, msg, title);
		}
		else {
			for (int ii = 0; ii < msg.length; ii++) {
				System.out.println(msg[ii]);
			}
		}
	}
}
