//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.CheckerSAX
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================

/**
 * @version 1.1
 */

package com.tetrasix.util;

import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;

import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class CheckerSAX {

    static public boolean check(String xmlfilename, Frame frame) {
        ResourceBundle _res;

        _res = ResourceBundle
                .getBundle("com.tetrasix.util.CheckerSAXResources");

        String parserClass = getClassName();
        try {
            Parser parser = ParserFactory.makeParser(parserClass);

            String fSep = System.getProperty("file.separator");
            if (fSep != null && fSep.length() == 1)
                    xmlfilename = xmlfilename.replace(fSep.charAt(0), '/');
            if (xmlfilename.length() > 0 && xmlfilename.charAt(0) != '/')
                    xmlfilename = '/' + xmlfilename;

            InputSource source = new InputSource(new FileInputStream(
                    xmlfilename));
            source.setSystemId("file://" + xmlfilename);
            parser.parse(source);

            String[] msg = new String[2];
            msg[0] = "Document successfully parsed";
            msg[1] = "Parser was : " + parserClass;

            Alerter.signal(frame, msg, _res.getString("msgtitle"));

            return true;
        } catch (FileNotFoundException e) {
            Alerter.signal(frame, "File not found : " + e.getMessage(), _res
                    .getString("msgtitle"));
        } catch (IOException e) {
            Alerter.signal(frame, "IO error : " + e.getMessage(), _res
                    .getString("msgtitle"));
        } catch (SAXParseException e) {
            String msg[] = new String[3];
            msg[0] = "SAX parse exception";
            msg[1] = "System identifier " + e.getSystemId() + ", line "
                    + e.getLineNumber() + ":" + e.getColumnNumber();
            msg[2] = e.getMessage();
            Alerter.signal(frame, msg, _res.getString("msgtitle"));
        } catch (SAXException e) {
            Alerter.signal(frame, "SAX exception : " + e.getMessage(), _res
                    .getString("msgtitle"));
        } catch (Exception e) {
            Alerter.signal(frame, e.getMessage(), _res.getString("msgtitle"));
        }

        return false;
    }

    static public String getClassName() {
        String parserClassName = Configuration.getProperty("sax.driver.class");
        if (parserClassName.equals("")) {
            parserClassName = "com.jclark.xml.sax.CommentDriver";
        }

        return parserClassName;
    }
}
