//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.Logotetrasix
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 * <p>This class displays tetrasix's logo or, if the
 * GIF file containing the logo is not available,
 * paint tetrasix name in several shades of red.</p>
 * <p>tetrasix logo is :</p>
 * <p><IMG ALT="TetraSix" SRC="images/LogoTetraSix.gif"></p>
 *
 * @version 1.1
 */


package com.tetrasix.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

public class Logo extends Canvas {
	
	Image _logo;
	Font _font;
	Dimension _dim;
	String _alt;

	/**
	 * <p>The constructor loads the image. It is not optimized for
	 * an access through the net</p>
	 */

	public Logo(String path, Dimension dim, String alt)
	{
		URL url = ClassLoader.getSystemResource(path);

		if (url != null) {
			_logo = Toolkit.getDefaultToolkit().getImage(url);
		}
		else {
			return;
		}

		_dim = dim;
		_alt = alt;

		MediaTracker tracker = new MediaTracker(this);
		tracker.addImage(_logo, 0);
		try {
			tracker.waitForAll(5000);
		}
		catch (InterruptedException e) {
			setSize(100, 100);
			return;
		}

		if (_logo.getWidth(this) <= 0) {
			if (dim != null) {
				setSize(dim);
			}
			else {
				setSize(100, 100);
			}
			_logo = null;
		}
		else {
			setSize(_logo.getWidth(this), _logo.getHeight(this));
		}
	}

	/**
	 * The <code>paint</code> method paints the Logo if it has been
	 * found, and four times tetrasix names in various shades of red if
	 * not
	 */

	public void paint(Graphics g)
	{
		if (_logo == null) {
			if (_font == null) {
				Font font = g.getFont();
				_font = new Font(font.getName(), font.getStyle() | Font.BOLD, font.getSize() * 3 / 2);
			}
			g.setFont(_font);

			Color color = Color.red;
			
			int ii;
			for (ii = 0; ii < 4; ii++) {
				g.setColor(color);
				color = color.darker();
				g.drawString(_alt, 10, 30 + ii * 30);
			}
		}
		else {
			g.drawImage(_logo, 1, 1, this);
		}
	}
}


