//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.RunLotusXSL
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package com.tetrasix.util;

import java.io.*;
import java.awt.*;
import java.lang.reflect.*;

public class RunXalan {

	static public void apply(String xmlfilename, String xslfilename, boolean browse, Frame frame)
	{
        PrintStream save_err = System.err;

		try {
      String htmlfilename = xmlfilename.substring(0, xmlfilename.length() - 4) + ".html";
      String logfilename = xmlfilename.substring(0, xmlfilename.length() - 4) + ".log";

			String argv[] = new String[6];

			int argc = 0;
			argv[argc++] = "-in";
			argv[argc++] = xmlfilename;
			argv[argc++] = "-xsl";
			argv[argc++] = xslfilename;
      argv[argc++] = "-out";
      argv[argc++] = htmlfilename;

			Class processor = Class.forName("org.apache.xalan.xslt.Process");

			Class[] paramtypes = { String[].class };
			Method main = processor.getMethod("main", paramtypes);
		
      System.setErr(new PrintStream(new FileOutputStream(logfilename)));
        
			Object[] args = { argv };

      System.err.println("Start runnning Xalan");

			main.invoke(null, args);

      System.err.println("Document generated : " + htmlfilename);

			if (browse && (new File(htmlfilename)).canRead()) {
				String browser = Configuration.getProperty("majix.tool.browser", "explorer.exe");
				Runtime.getRuntime().exec(browser + " " + htmlfilename);
			}
		}
		catch (ClassNotFoundException e) {
			new MessageBox(frame, "Unable to found org.apache.xalan.xslt.Process : " + e.getMessage());
		}
		catch (IOException e) {
			new MessageBox(frame, "Unable to execute LotusXSL : " + e.getMessage());
		}
		catch (Exception e) {
			new MessageBox(frame, "unexpected exception when running LotusXSL : " + e.getMessage());
		}
        finally {
            System.setErr(save_err);
        }
	}

	static public boolean isAvailable()
	{
		try {
			Class processor = Class.forName("org.apache.xalan.xslt.Process");
			return true;
		}
		catch (ClassNotFoundException e) {
			return false;
		}
	}
}