//===============================================================
// package : com.tetrasix.majix
// class : com.tetrasix.majix.WideList
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.util;

import java.awt.List;
import java.awt.Dimension;

public class WideList extends List {

	int _factor;

	public WideList(int nbrows, int factor)
	{
		super(nbrows, false);
		_factor = factor;
	}

	public Dimension getPreferredSize()
	{
		Dimension ps = super.getPreferredSize();

		ps.width = _factor * ps.width;

		return ps;
	}

	public Dimension getPreferredSize(int nbrows)
	{
		Dimension ps = super.getPreferredSize(nbrows);

		ps.width = _factor * ps.width;

		return ps;
	}

	public Dimension getMinimumSize()
	{
		Dimension ps = super.getMinimumSize();

		ps.width = _factor * ps.width;

		return ps;
	}

	public Dimension getMinimumSize(int nbrows)
	{
		Dimension ps = super.getMinimumSize(nbrows);

		ps.width = _factor * ps.width;

		return ps;
	}
}
