/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.ejb.session.interfaces;

import java.util.Collection;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;

/**
 * Session bean interface that manages the access to all address related beans/tables in the db.
 * It allows the retrieval of zip/ocality/coutry etc.... 
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: AddressManagerInterface.java,v $
 * <br>Revision 1.7  2012-11-30 08:00:59  ferring
 * <br>postal code added to country and to formatter
 * <br>Short patient title corrected and long patient title added
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-06-30 08:16:45  hermen
 * <br>added address autocompletion by locality
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-12 15:10:23  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */

public interface AddressManagerInterface {

	/**
	 * searchs for valid luxembourgish localities with the given string
	 * @param name the string to search for
	 * @return an array of found localities
	 * @throws Exception
	 */
	public Collection<Locality> searchLocality(String name) throws Exception;
	
	/**
	 * returns all valid zip codes for the given locality 
	 * @param localityId
	 * @return
	 * @throws Exception
	 */
	public Integer[] getZipByLocality(Integer localityId) throws Exception;
	
	/**
	 * returns all luxembourgish zip codes
	 * @return
	 * @throws Exception
	 */
	public Zip[] getZips() throws Exception;
	
	/**
	 * returns all valid streets for the given luxembourgish zip code
	 * @param zip
	 * @return
	 * @throws Exception
	 */
	public String[] getStreetByZip(Integer zip) throws Exception;
	
	/**
	 * returns all valid streets for the given luxembourgish locality id
	 * @param locality id
	 * @return
	 * @throws Exception
	 */
	public String[] getStreetLocalityID(Integer id) throws Exception;
	
	/**
	 * returns all valid countries from the db
	 * @return
	 * @throws Exception
	 */
	public String[] getCountries() throws Exception;
	
	/**
	 * returns all valid localities from the db
	 * @return
	 * @throws Exception
	 */
	public Locality[] getLocalities() throws Exception;
	
	/**
	 * returns all valid addres types from the db
	 * @return
	 * @throws Exception
	 */
	public String[] getTypes() throws Exception;
	
	/**
	 * returns the Locality by its id
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public Locality getLocality(Integer id) throws Exception;

	
	/**
	 * returns all zips for this zipcode
	 * @param zipcode
	 * @return
	 */
	public Zip[] getZipByCode(Integer zipcode);

	/**
	 * @param currentLocality The locality to search for.  This may NOT be <code>null</code>.
	 * @param streetName The street to search for. This may NOT be <code>null</code>.
	 * @param streetNumber The street number to search for. This may be <code>null</code>.
	 * @return The found ZIP code, if and only if, it is the only ZIP code that fits to the parameter.<br>
	 * 	Otherwise <code>null</code> is returned.
	 * @throws Exception
	 */
	public Zip getZipByLocalityAndStreet (Locality currentLocality, String streetName, String streetNumber) throws Exception;;

	public String getPostalCodeFromCountry (String countryName);
	
	public String getAlpha3CodeFromCountry (String countryName);
}

