/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.i18n.Translatrix;

public class AddressModuleLoader 
	{
	private static boolean m_Loaded = false;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public AddressModuleLoader ()
	{
	InitAddressModule ();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public static void InitAddressModule ()
	{
	if (m_Loaded == false)
		{
		Translatrix.addBundle("lu.tudor.santec.gecamed.address.gui.resources.WidgetResources");
		Translatrix.addBundle("lu.tudor.santec.gecamed.address.utils.resources.ServerResources");
		m_Loaded = true;
		}
	}

//---------------------------------------------------------------------------
/** returns the ImageIcon Resource specified by p_IconName.
* @param p_IconName specifies the name of the icon to get from application resources.
* @return the ImageIcon specified by p_IconName, or <CODE>null</CODE> if specified does not exist.
*/
//---------------------------------------------------------------------------

public static ImageIcon getIconResource (String p_IconName) 
{
	return IconFetcher.getIcon(AddressModuleLoader.class, p_IconName);
}
//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
}
