/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class LocalityStub
	{
	private Integer m_LocalityId;
	private Integer m_Operation;
	private String  m_LocalityName;
	private String  m_MunicipalityName;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public static final int	c_None    = 0;
	public static final int	c_Added   = 1;
	public static final int c_Removed = 2;
	
//***************************************************************************
//* Constructor                                                         	*
//***************************************************************************
//---------------------------------------------------------------------------

public LocalityStub ()
	{
	m_LocalityId 		= 0;
	m_Operation  		= c_None;
	m_LocalityName      = new String ("");
	m_MunicipalityName  = new String ("");
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                         		*
//***************************************************************************
//---------------------------------------------------------------------------
	
public Integer getLocalityId ()
	{
	return m_LocalityId;
	}
	
//---------------------------------------------------------------------------

public void setLocalityId (Integer p_LocalityId)
	{
	m_LocalityId = p_LocalityId;
	}
	
//---------------------------------------------------------------------------

public Integer getOperation ()
	{
	return m_Operation;
	}
	
//---------------------------------------------------------------------------

public void setOperation (Integer p_Operation)
	{
	m_Operation = p_Operation;
	}
	
//---------------------------------------------------------------------------

public String getLocalityName ()
	{
	return m_LocalityName;
	}
	
//---------------------------------------------------------------------------

public void setLocalityName (String p_LocalityName)
	{
	m_LocalityName = p_LocalityName;
	}
	
//---------------------------------------------------------------------------

public String getMunicipalityName ()
	{
	return m_MunicipalityName;
	}
	
//---------------------------------------------------------------------------

public void setMunicipalityName (String p_MunicipalityName)
	{
	m_MunicipalityName = p_MunicipalityName;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
