/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * InvoiceListModel.java
 *
 * Created on March 31, 2006
 */

package lu.tudor.santec.gecamed.address.gui.addressmanagement;

/**
 *
 * @author  santec
 */


import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class ZIPListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
  	
    private Vector      	<Zip> m_ZIPs;        
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
    
    public static final String c_IDHeader 				= "ZIPStubListModel.IDHeader";
    public static final String c_StreetNameHeader		= "ZIPStubListModel.StreetNameHeader";
    public static final String c_ZIPHeader				= "ZIPStubListModel.ZIPHeader";
    public static final String c_LocalityNameHeader		= "ZIPStubListModel.LocalityNameHeader";
    public static final String c_ParityHeader 			= "ZIPStubListModel.ParityHeader";
    public static final String c_FirstHeader 			= "ZIPStubListModel.FirstHeader";
    public static final String c_LastHeader 			= "ZIPStubListModel.LastHeader";
          
    public static final int    c_IDColumn 				= 0;
    public static final int    c_ZIPColumn				= 1;
    public static final int    c_StreetNameColumn		= 2;
    public static final int    c_LocalityNameColumn		= 3;
    public static final int    c_ParityColumn			= 4;
    public static final int    c_FirstColumn			= 5;
    public static final int    c_LastColumn				= 6;
     
    static final public String c_TableHeaders [] = { 	c_IDHeader,
    													c_ZIPHeader,
    													c_StreetNameHeader,
    													c_LocalityNameHeader,
    	 												c_ParityHeader,
    	 												c_FirstHeader,
    	 												c_LastHeader };
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public ZIPListModel ()
    {
	m_ZIPs	= new Vector <Zip> ();
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_ZIPs.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Zip	l_ZIPStub = null;
  
    if ((p_Row >= 0) && (p_Row < m_ZIPs.size()))
        {
    	l_ZIPStub  = m_ZIPs.elementAt (p_Row);
         }
	 
	if (l_ZIPStub == null) l_ZIPStub = new Zip ();

	switch (p_Column)
        {
        case  c_IDColumn:    		return l_ZIPStub.getId();  
        case  c_StreetNameColumn: 	return (l_ZIPStub.getStreet() != null) ? (l_ZIPStub.getStreet()) : "";    
        case  c_ZIPColumn: 			return (l_ZIPStub.getZip() != null) ? (l_ZIPStub.getZip()) : 0;    
        case  c_LocalityNameColumn: return (l_ZIPStub.getLocalityId() != null) ? (l_ZIPStub.getLocalityId()) : "";    
        case  c_ParityColumn: 		return (l_ZIPStub.getParity() != null) ? (l_ZIPStub.getParity()) : Zip.NONE;    
        case  c_FirstColumn: 		return (l_ZIPStub.getFirst() != null) ? (l_ZIPStub.getFirst()) : 0;    
        case  c_LastColumn: 		return (l_ZIPStub.getLast() != null) ? (l_ZIPStub.getLast()) : 0;    
             
        default: return "";
        }
    }
//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
    return false;
    }
 
//---------------------------------------------------------------------------

public Zip	getZIPAt (int p_Row)
    {
	Zip  l_Stub;
     
    if ((p_Row >= 0) && (p_Row < m_ZIPs.size()))
        {
    	l_Stub = m_ZIPs.elementAt (p_Row);
        return l_Stub;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void addLocality (Zip p_Stub)
    {
    int	l_Row;
	
	if (p_Stub != null)    
        {    
		m_ZIPs.addElement (p_Stub);
    		
		l_Row = m_ZIPs.size() - 1;
		
    	fireTableRowsInserted (l_Row,l_Row);
        }
    }
	
//---------------------------------------------------------------------------

public void removeAll ()
	{
	int	l_LastRow;
	
	l_LastRow = m_ZIPs.size() -1;
	
	m_ZIPs.removeAllElements ();
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}


//---------------------------------------------------------------------------

public void setZIPs (Collection <Zip> p_Stubs)
    {
     if (p_Stubs == null) return;
        
    removeAll ();
    m_ZIPs.addAll (p_Stubs);
    fireTableRowsInserted (0,m_ZIPs.size());
    }

//---------------------------------------------------------------------------

public Set <Zip> getZIPs ()
    {
	HashSet <Zip> l_Stubs;
	
	l_Stubs = new HashSet <Zip> (m_ZIPs);
	
	return l_Stubs;
	}   
 

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
