/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;
import lu.tudor.santec.gecamed.address.gui.AddressModuleLoader;
import lu.tudor.santec.gecamed.billing.gui.GenericListRenderer;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************
public class ZIPListRenderer extends GenericListRenderer
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private ImageIcon					m_AddedOperation;
	private ImageIcon					m_RemovedOperation;
	
	private ZIPListModel			m_TableModel;
	private	TableSorter					m_InvoiceSorter;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public ZIPListRenderer ()
	{
	super();
	      
	m_AddedOperation   = AddressModuleLoader.getIconResource("added_operation.png");
	m_RemovedOperation = AddressModuleLoader.getIconResource("removed_operation.png");
	}

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

public void formatOperation (ZIPStub p_Stub)
	{
	
	switch (p_Stub.getOperation())
		{
		case ZIPStub.c_Added: 		m_Label.setIcon(m_AddedOperation);
									break;
		case ZIPStub.c_Removed: 	m_Label.setIcon(m_RemovedOperation);
									break;
		}
	}

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_InvoiceSorter != null) && m_InvoiceSorter.isSorting())
		{
		l_ModelRow = m_InvoiceSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component 		l_Component;
	int				l_Column;
	int				l_Row;
	Zip			l_Stub;
	
	l_Component = super.getTableCellRendererComponent(p_Table, p_Value, p_IsSelected, p_HasFocus, p_Row, p_Column);
	l_Stub		= null;
	
	if (m_TableModel == null) 
		{
		m_InvoiceSorter = (TableSorter) p_Table.getModel();
		m_TableModel 	= (ZIPListModel) m_InvoiceSorter.getTableModel();
		}
	
	if (m_TableModel != null)  //&& (p_Row != m_LastRow))
		{
		l_Row = this.modelRow (p_Row);
		l_Stub = m_TableModel.getZIPAt(l_Row);
		}
	
	if ((p_Value != null) && (l_Stub != null))
		{
		l_Column = this.modelColumn(p_Table, p_Column);

		
		switch (l_Column)
			{
			case ZIPListModel.c_IDColumn :
				
			    m_Label.setHorizontalAlignment (SwingConstants.CENTER);
			    m_Label.setText(p_Value + "");
				
				break;
			
			case ZIPListModel.c_StreetNameColumn :
			
				m_Label.setText((String)p_Value);
			    m_Label.setHorizontalAlignment (SwingConstants.LEFT);
				break;
			
			case ZIPListModel.c_LocalityNameColumn :
				
			    m_Label.setHorizontalAlignment (SwingConstants.LEFT);
			    try {
			    	m_Label.setText(getLocalityName((Integer) p_Value));					
				} catch (Exception e) {
					e.printStackTrace();
				}
				break;
			
			case ZIPListModel.c_ZIPColumn :

			    m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				m_Label.setText("L-" + p_Value.toString());
				break;

			case ZIPListModel.c_ParityColumn :

			    m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				m_Label.setText(Translatrix.getTranslationString("ZipEditDialog."+p_Value));
				break;
			
			case ZIPListModel.c_FirstColumn :
			case ZIPListModel.c_LastColumn :

			    m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				if (((Integer)p_Value).intValue() > 0)
					m_Label.setText(p_Value.toString());
				else m_Label.setText("");
					
				break;
				
			default: m_Label.setText((String)p_Value);
			}
		}
				
	return m_Label;
	}

	private String getLocalityName(Integer localityId) {
		Locality l = ((Locality)GECAMedLists.getIdMapReference(Locality.class).get(localityId));
		if (l != null) {
			return l.toString();			
		} else {
			return "";
		}
	}
	
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
