/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class ZIPStub
	{
	private Integer 	m_ZIPId;
	private Integer 	m_Operation;
	private String		m_StreetName;
	private String  	m_LocalityName;
	private String  	m_MunicipalityName;
	private Integer 	m_ZIPCode;
	private Character	m_Parity;
	private Integer 	m_First;
	private Integer 	m_Last;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public static final int	c_None    = 0;
	public static final int	c_Added   = 1;
	public static final int c_Removed = 2;
	
//***************************************************************************
//* Constructor                                                         	*
//***************************************************************************
//---------------------------------------------------------------------------

public ZIPStub ()
	{
	m_ZIPId				= 0;
	m_Operation  		= c_None;
	m_StreetName		= new String ("");
	m_LocalityName      = new String ("");
	m_MunicipalityName  = new String ("");
	m_ZIPCode			= 0;
	m_Parity			= Zip.NONE;
	m_First				= 0;
	m_Last				= 0;
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                         		*
//***************************************************************************
//---------------------------------------------------------------------------
	
public Integer getZIPId ()
	{
	return m_ZIPId;
	}
	
//---------------------------------------------------------------------------

public void setLocalityId (Integer p_ZIPId)
	{
	m_ZIPId = p_ZIPId;
	}
	
//---------------------------------------------------------------------------

public Integer getOperation ()
	{
	return m_Operation;
	}
	
//---------------------------------------------------------------------------

public void setOperation (Integer p_Operation)
	{
	m_Operation = p_Operation;
	}
	
//---------------------------------------------------------------------------

public String getStreetName ()
	{
	return m_StreetName;
	}
	
//---------------------------------------------------------------------------

public void setStreetName (String p_StreetName)
	{
	m_StreetName = p_StreetName;
	}
	
//---------------------------------------------------------------------------

public String getLocalityName ()
	{
	return m_LocalityName;
	}
	
//---------------------------------------------------------------------------

public void setLocalityName (String p_LocalityName)
	{
	m_LocalityName = p_LocalityName;
	}
	
//---------------------------------------------------------------------------

public String getMunicipalityName ()
	{
	return m_MunicipalityName;
	}
	
//---------------------------------------------------------------------------

public void setMunicipalityName (String p_MunicipalityName)
	{
	m_MunicipalityName = p_MunicipalityName;
	}

//---------------------------------------------------------------------------

public Integer getZIPCode ()
	{
	return m_ZIPCode;
	}
	
//---------------------------------------------------------------------------

public void setZIPCode (Integer p_ZIPCode)
	{
	m_ZIPCode = p_ZIPCode;
	}
	
//---------------------------------------------------------------------------

public Character getParity ()
	{
	return m_Parity;
	}
	
//---------------------------------------------------------------------------

public void setParity (Character p_Parity)
	{
	m_Parity = p_Parity;
	}
	
//---------------------------------------------------------------------------

public Integer getFirst ()
	{
	return m_First;
	}
	
//---------------------------------------------------------------------------

public void setFirst (Integer p_First)
	{
	m_First = p_First;
	}

//---------------------------------------------------------------------------

public Integer getLast ()
	{
	return m_Last;
	}
	
//---------------------------------------------------------------------------

public void setLast (Integer p_Last)
	{
	m_Last = p_Last;
	}
	
//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
