/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;

import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;

public class LocalitySearchPopup extends JPopupMenu implements MouseListener {

    private static final long serialVersionUID = 1L;
    private LocalityListModel listModel;
    JList list;
    private JScrollPane scrollpane;
    
    public LocalitySearchPopup() {
	initComponents();
    }

    /**
     *  Initialises the components
     */
    private void initComponents() {
    	// Init JPopupMenu
	setOpaque(true);
    	setLayout(new GridLayout(1,1));
    	this.setFocusable(false);

        setBackground(new Color(255, 255, 255));
//    	setBackground(Color.RED);

        // ListModel
        this.listModel = new LocalityListModel();
        this.list = new JList();
        this.list.setModel(listModel);

        // Mouse Listener
        this.list.addMouseListener(this);

        this.list.setFont(new Font("Arial",Font.PLAIN,10));

        // ScrollPane
        this.scrollpane = new JScrollPane(this.list);
        this.scrollpane.setBorder(BorderFactory.createEmptyBorder());
        // List to ScrollPane
        //this.scrollpane.add(this.list);
        this.add(this.scrollpane);

    }

    public void mouseClicked(MouseEvent e) { }
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) { }
    public void mousePressed(MouseEvent e) { }

    public void mouseReleased(MouseEvent e) {
	this.setVisible(false);
	
    }
    
    
    public void setLocalities(Collection<Locality> localities) {
	this.listModel.setLocalities(localities);
    }

    
}
