/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SGGAParser
	{
	private SAXParser	m_Parser;
	private SGGAHandler	m_SGGAHandler;
	private File		m_XMLFile;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public SGGAParser (File p_SGGAFile)
	{
	m_XMLFile = p_SGGAFile;
	}
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void parse ()
	{
	SAXParserFactory	l_ParserFactory;
	
	if ((m_XMLFile != null) && m_XMLFile.canRead())
		{
		try	{
			l_ParserFactory = SAXParserFactory.newInstance();
			m_Parser = l_ParserFactory.newSAXParser();
			m_SGGAHandler = new SGGAHandler ();
			m_Parser.parse(new InputSource( new FileReader (m_XMLFile)),m_SGGAHandler);
			}
		catch (SAXException p_Exception)
			{
			p_Exception.printStackTrace();
			} 
		catch (ParserConfigurationException p_Exception)
			{
			p_Exception.printStackTrace();
			} 
		catch (IOException e) 
			{
			e.printStackTrace();
			}
		}
	}		

//---------------------------------------------------------------------------

public Collection <Zip> getZips ()
	{
	if (m_SGGAHandler != null)
		{
		m_SGGAHandler.resolveDependencies();
		return m_SGGAHandler.getZips();
		}
		
	else return null;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
