/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>addressbook.contact_address</b> table
 * which stores the addresses of the contact persons
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ContactAddress.java,v $
 * <br>Revision 1.9  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * <br>Revision 1.8  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.7  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-05-08 09:02:17  hermen
 * <br>changed formatting
 * <br>
 * <br>Revision 1.5  2008-05-06 12:32:12  hermen
 * <br>added export
 * <br>
 * <br>Revision 1.4  2008-05-05 14:32:15  hermen
 * <br>added vcard import
 * <br>
 * <br>Revision 1.3  2008-04-30 12:28:14  hermen
 * <br>updated formatting
 * <br>
 * <br>Revision 1.2  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 * <br>Revision 1.1  2008-04-29 09:14:40  hermen
 * <br>initial checkin of addressbook module
 * <br>
 *
 */
@Entity
@Table(name = "contact_address", schema = "addressbook")
public class ContactAddress extends GECAMedAddressBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private Integer contactId;
	private String postbox;
	
	/**
	 * Get the contactId.
	 *
	 * @return The contactId.
	 */
	@javax.persistence.Column(name = "contact_id")
	public Integer getContactId() {
		return contactId;
	}

	/**
	 * Set the contactId.
	 *
	 * @param contactId The contactId.
	 */
	public void setContactId(Integer contactId) {
		this.contactId = contactId;
	}

	/**
	 * @return the postbox
	 */
	@javax.persistence.Column(name = "postbox")
	public String getPostbox() {
	    return postbox;
	}

	/**
	 * @param postbox the postbox to set
	 */
	public void setPostbox(String postbox) {
	    this.postbox = postbox;
	}
	

	public String toString() {
		return (this.getStreetNumber()!=null && !this.getStreetNumber().equals("") ?  this.getStreetNumber() + ", " :  "") + 
			this.getStreetName() + " " + 
			this.getZip() + " " + 
			this.getLocality() + ", " + 
			this.getCountryLocalized();
	}
	
	public String toStringMultiLine() {
		return (this.getStreetNumber()!=null && !this.getStreetNumber().equals("") ?  this.getStreetNumber() + ", " :  "") + 
			this.getStreetName() + "\n" + 
			this.getZip() + " " + 
			this.getLocality() + "\n" + 
			this.getCountryLocalized();
	}
	
	public int compareTo(GECAMedEntityBean o) {
		try {
			if (this.date.before(((ContactAddress)o).date)) {
				return -1;
			}	
		} catch (Exception e) {
		}
		return 1;
	}
	
	public String toVCardString() {
		return ";;" +
			this.getStreetName() + " " + 
			(this.getStreetNumber()!=null?  this.getStreetNumber() :  "") + ";" +
			this.getLocality() + ";;" + 
			this.getZip() + ";" + 
			this.getCountry();
	}
	
	
	/**
	 * Returns a formatted address string in two lines
	 * 
	 * @return
	 */
	@Transient
	public String getFormattedString() {
		/* ====================================================== */
		StringBuffer buff = new StringBuffer();
		// streetnumber
		buff.append((this.getStreetNumber() == null || this.getStreetNumber().equals("") ? 
				"" : this.getStreetNumber() + ", "));
		/* ------------------------------------------------------ */
		// streetname
		buff.append(getStreetName() == null || getStreetName().equals("") ?
				"" : getStreetName());
		/* ------------------------------------------------------ */
		// new line
		buff.append("\n");
		/* ------------------------------------------------------ */
		// Country
		buff.append(getCountryLocalized() == null || getCountryLocalized().equals("") ?
				"" : getCountryLocalized().substring(0, 1).toUpperCase()+ " - ");
		/* ------------------------------------------------------ */
		// zip
		buff.append(getZip() == null || getZip().equals("") ?
				"" : getZip()+" ");
		/* ------------------------------------------------------ */
		// ciddy
		buff.append(getLocality() == null || getLocality().equals("") ?
				"" : getLocality());
		/* ------------------------------------------------------ */
		return buff.toString();
		/* ====================================================== */
	}
	
}
