/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JPanel;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.contactpanels.ContactAdditionalPanel;
import lu.tudor.santec.gecamed.addressbook.gui.contactpanels.ContactAddressPanel;
import lu.tudor.santec.gecamed.addressbook.gui.contactpanels.ContactCommentPanel;
import lu.tudor.santec.gecamed.addressbook.gui.contactpanels.ContactNamePanel;
import lu.tudor.santec.gecamed.addressbook.gui.contactpanels.ContactPhonePanel;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Dialog to edit and Create new Contacts in the Addressbook 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ContactEditDialog.java,v $
 * <br>Revision 1.7  2009-07-02 11:50:43  hermen
 * <br>fixed address/zipcode bug
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-05-08 14:04:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-05-07 13:25:23  hermen
 * <br>updated import
 * <br>
 * <br>Revision 1.3  2008-05-06 14:29:13  hermen
 * <br>updated javadoc
 * <br>
 *
 */
public class ContactEditDialog extends GECAMedBaseDialog implements
		ActionListener {

	private static final long serialVersionUID = 1L;

	private boolean state;
//
//	private JButton cancelButton;
//
//	private JButton okButton;

	private ContactNamePanel contactNamePanel;

	private ContactPhonePanel contactPhonePanel;

	private ContactCommentPanel contactCommentPanel;

	private ContactAdditionalPanel contactAdditionalPanel;

	private ContactAddressPanel contactAddressPanel;

	private Contact contact;

	private JPanel mainPanel;

	private ContactEditDialog(String title, boolean b) {
		super(title, b);
	}

	public ContactEditDialog() {
		this(Translatrix.getTranslationString("Addressbook.addContact"), true);
		//	super(MainFrame.getInstance(), true);

		//	this.setTitle(Translatrix.getTranslationString("Addressbook.addContact"));
		
		this.mainPanel = new JPanel(new BorderLayout());
		mainPanel.setLayout(new BorderLayout());
		mainPanel.setBackground(GECAMedColors.c_GECAMedBackground);

		mainPanel.add(this.getContactPanel(), BorderLayout.CENTER);
		this.enableCancelKeyMapping(true);
		this.enableOkKeyMapping(false);
		
		
		this.addMainPanel(mainPanel);
		
//		this.cancelButton = new JButton(Translatrix
//				.getTranslationString("core.cancel"));
		this.cancelButton.addActionListener(this);
//
//		this.okButton = new JButton(Translatrix.getTranslationString("core.ok"));
		this.okButton.addActionListener(this);


		this.pack();

	}

	private JPanel getContactPanel() {
		JPanel jp = new JPanel(new FormLayout(
				"3dlu, pref:grow, 3dlu, pref:grow, 3dlu",
				"3dlu, fill:pref, 3dlu, fill:pref, 3dlu, fill:pref, 3dlu"));
		jp.setOpaque(false);
		CellConstraints cc = new CellConstraints();

		this.contactNamePanel = new ContactNamePanel(this);
		jp.add(contactNamePanel, cc.xy(2, 2));
		this.contactPhonePanel = new ContactPhonePanel(this);
		jp.add(contactPhonePanel, cc.xy(4, 2));

		this.contactAddressPanel = new ContactAddressPanel(this);
		jp.add(contactAddressPanel, cc.xyw(2, 4, 3));

		this.contactCommentPanel = new ContactCommentPanel(this);
		jp.add(contactCommentPanel, cc.xy(2, 6));
		this.contactAdditionalPanel = new ContactAdditionalPanel(this);
		jp.add(contactAdditionalPanel, cc.xy(4, 6));

		return jp;
	}

	public boolean showDialog(Contact contact) {
		setContact(contact);
		this.setLocationRelativeTo(MainFrame.getInstance());
		this.setVisible(true);
		return state;
	}

	private void setContact(Contact contact) {
		if (contact != null && contact.isPersistent())
			this.setTitle(Translatrix
					.getTranslationString("Addressbook.editContact"));
		else
			this.setTitle(Translatrix
					.getTranslationString("Addressbook.addContact"));
		this.contact = contact;
		this.contactNamePanel.setContact(contact, true);
		this.contactPhonePanel.setContact(contact, true);
		this.contactAddressPanel.setContact(contact, true);
		this.contactCommentPanel.setContact(contact, true);
		this.contactAdditionalPanel.setContact(contact, true);
	}

	public Contact getContact() {
		this.contactNamePanel.getContact(contact);
		this.contactPhonePanel.getContact(contact);
		this.contactAddressPanel.getContact(contact);
		this.contactCommentPanel.getContact(contact);
		this.contactAdditionalPanel.getContact(contact);
		return contact;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.cancelButton)) {
			state = false;
		} else if (e.getSource().equals(this.okButton)) {
			state = true;
		}
		this.setVisible(false);
	}

}
