/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.contactpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.ContactEditDialog;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.Language;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.Nationality;
import lu.tudor.santec.gecamed.core.gui.utils.AutoCompletion;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.gecamed.patient.gui.simpleview.OverviewPanel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

/**
 * 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ContactAdditionalPanel.java,v $
 * <br>Revision 1.7  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2010-10-19 14:37:15  troth
 * <br>rename class SimpleViewPanel in OverviewPanel
 * <br>
 * <br>Revision 1.5  2010-03-12 14:12:56  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-06 08:17:58  hermen
 * <br>improved import and rendering
 * <br>
 * <br>Revision 1.2  2008-04-30 13:09:51  hermen
 * <br>added sidebar
 * <br>
 * <br>Revision 1.1  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 *
 */
public class ContactAdditionalPanel extends HeaderedPanel implements KeyListener, IContactDataPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;
    
	public static final String NONE = "-";

    //~ Instance fields ========================================================

    private JDateChooser dob;
    private JComboBox language;
    private JComboBox nationality;

	private JPanel mainPanel;
	private CellConstraints cc;

	private String[] languageArray;
	private String[] nationalityArray;

    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public ContactAdditionalPanel(ContactEditDialog contactEditDialog)
    {
    	this.setOpaque(false);
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    @SuppressWarnings("unchecked")
    public void getContact(Contact contact) {
	
        	contact.setBirthDate(this.dob.getDate());

        	if (language.getSelectedItem() instanceof ComboBoxElement) {
        		contact.setLanguage(((ComboBoxElement<Language>)language.getSelectedItem()).getValue().getValue());
        	} else {
        		contact.setLanguage((String) language.getSelectedItem());
        	}
        	
        	if (nationality.getSelectedItem() instanceof ComboBoxElement) {
        		contact.setNationality(((ComboBoxElement<Nationality>)nationality.getSelectedItem()).getValue().getValue());
        	} else {
        		contact.setNationality((String) nationality.getSelectedItem());
        	}

    }

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setContact(Contact contact, boolean editable)
    {
    	
    	setEditable(editable);

     	this.dob.setDate(contact.getBirthDate());
     	if (contact.getLanguage() != null) {
     		int index = GECAMedGuiUtils.getIndexByDefaultTranslation(language, contact.getLanguage());
     		if (index > 0) {
     			this.language.setSelectedIndex(index);      			
     		} else {
     			this.language.setSelectedItem(contact.getLanguage());  
     		}	
     	} else {
            this.language.setSelectedIndex(GECAMedGuiUtils.getIndexByDefaultTranslation(language, Language.LUXEMBOURGISH));
     	}
     	if (contact.getNationality() != null) {
     		int index = GECAMedGuiUtils.getIndexByDefaultTranslation(nationality, contact.getNationality());
     		if (index > 0) {
     			this.nationality.setSelectedIndex(index);      			
     		} else {
     			this.nationality.setSelectedItem(contact.getNationality());  
     		}
     	} else {
     		this.nationality.setSelectedIndex(GECAMedGuiUtils.getIndexByDefaultTranslation(nationality, Nationality.LUXEMBOURGISH));
     	}
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel() {
    	/* ================================================== */
    	this.setHeader(Translatrix.getTranslationString("Addressbook.additional")+":");
//    	this.setHeaderIcon(IconFetcher.getMediumIcon(AddressbookModule.class, AddressbookModule.ICON_LANGUAGE));
    	
    	this.enableAlpha(true);
    	this.cc = new CellConstraints();
    	
        initComponents();
        buildViewPanel();
        
        this.setLayout(new BorderLayout());
        this.add(mainPanel, BorderLayout.CENTER);
     
    }


    /**
     * build the gui of the panel
     */
    private void buildViewPanel() {
    	/* ================================================== */
    	
    	this.mainPanel = new JPanel(new FormLayout(
    										// cols
    										"3dlu," +
    										"right:50dlu," +
    										"5dlu," +
    										
    										"fill:90dlu," +
    										"fill:pref:grow",
    										// rows
    										"3dlu," +
    										"fill:pref," +
    										"3dlu," +
    										"fill:pref," +
    										"3dlu," +
    										"fill:pref," +
    										"3dlu," +
    										"fill:pref," +
    										"3dlu,"
    										));
    	mainPanel.setOpaque(false);
    	/* ------------------------------------------------------- */
    	JLabel dobLabel    = OverviewPanel.createLabel("Addressbook.dob");
    	JLabel languageLabel    = OverviewPanel.createLabel("Addressbook.language");
    	JLabel nationalityLabel = OverviewPanel.createLabel("Addressbook.nationality");
    	
    	
    	/* ------------------------------------------------------- */
    	// place the labels
    	mainPanel.add(dobLabel, 		cc.xy(2, 2));
    	mainPanel.add(languageLabel,         cc.xy(2, 4));
    	mainPanel.add(nationalityLabel, 		cc.xy(2, 6));
    	
    	/* ------------------------------------------------------- */
    	// place the fields
    	
    	mainPanel.add(this.dob,    cc.xy(4, 2));
    	mainPanel.add(this.language, cc.xy(4, 4));
    	mainPanel.add(this.nationality,   cc.xy(4, 6));
		/* ================================================== */
    }
    
    
    
    /**
     * initializes the Components
     */
    private void initComponents()
    {
	 // Get the type manager
//	try {
//		ListManagerInterface manager = 
//			(ListManagerInterface) ManagerFactory.getRemote(ListManagerBean.class);
//		languageArray = manager.getLanguages();
//		nationalityArray = manager.getNationalities();
//	} catch (Exception e) {
//    		MainFrame.reportServerError(e);
//	}
	
        this.dob = GECAMedGuiUtils.getDateChooser(false);
        this.dob.addKeyListener(this);
        
        this.language = new JComboBox(GECAMedGuiUtils.getTranslatedList(Language.class));
        try {
        	this.language.setSelectedIndex(GECAMedGuiUtils.getIndexByDefaultTranslation(language, Language.LUXEMBOURGISH));
		} catch (Exception e) {}
        AutoCompletion.enableWithFreeText(this.language);
        
        this.nationality = new JComboBox(GECAMedGuiUtils.getTranslatedList(Nationality.class));
        try {
        	this.nationality.setSelectedIndex(GECAMedGuiUtils.getIndexByDefaultTranslation(nationality, Nationality.LUXEMBOURGISH));
		} catch (Exception e) {}
        AutoCompletion.enableWithFreeText(this.nationality);
        
	Dimension d = dob.getPreferredSize();
	language.setPreferredSize(d);
	nationality.setPreferredSize(d);
        
    }

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
//		if (listenersActivated )
//			this.patientEditPanel.setModified(true);
	}
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
	}
	
	/**
	 * enables the panel to be edited
	 * @param editable
	 */
	private void setEditable(boolean editable) {
		this.dob.setEnabled(editable);
        	this.language.setEditable(editable);
        	this.nationality.setEditable(editable);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getComponentsForFocus()
	 */
	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		List<Component> list = new ArrayList<Component>();
		/* ------------------------------------------------------- */
		list.add(dob);
		list.add(language);
		list.add(nationality);
		/* ------------------------------------------------------- */
		return list;
		/* ====================================================== */
	}
}
