/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.contactpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JTextArea;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.ContactEditDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;


public class ContactCommentPanel extends HeaderedPanel implements KeyListener, IContactDataPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ========================================================

        private ContactEditDialog contactEditDialog;
	private boolean listenersActivated;
	private JPanel mainPanel;
	private CellConstraints cc;

	private JTextArea comment;

    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public ContactCommentPanel(ContactEditDialog contactEditDialog)
    {
    	this.setOpaque(false);
    	this.contactEditDialog = contactEditDialog;
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    @SuppressWarnings("unchecked")
    public void getContact(Contact contact) {
		contact.setComment(this.comment.getText());
    }

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setContact(Contact contact, boolean editable)
    {
    	
    	setEditable(editable);
    	
    	this.listenersActivated = false;

    	this.comment.setText(contact.getComment() != null ? contact.getComment() : "");
        
        this.listenersActivated = true;
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel() {
    	/* ================================================== */
    	this.setHeader(Translatrix.getTranslationString("Addressbook.comment")+":");
//    	this.setHeaderIcon(IconFetcher.getMediumIcon(AddressbookModule.class, AddressbookModule.ICON_COMMENT));
    	
    	this.enableAlpha(true);
    	this.cc = new CellConstraints();
    	
        initComponents();
        buildViewPanel();
        
        this.setLayout(new BorderLayout());
        this.add(mainPanel, BorderLayout.CENTER);
     
    }


    /**
     * build the gui of the panel
     */
    private void buildViewPanel() {
    	/* ================================================== */
    	
    	this.mainPanel = new JPanel(new FormLayout(
    										// cols
    										"3dlu," +
    										"right:50dlu," +
    										"5dlu," +
    										
    										"fill:90dlu," +
    										"fill:pref:grow",
    										// rows
    										"3dlu," +
    										"fill:pref," +   
    										"3dlu," +
    										"fill:pref:grow," +
    										"3dlu"));
    	mainPanel.setOpaque(false);
    	/* ------------------------------------------------------- */
    	mainPanel.add(this.comment,    cc.xywh(2, 2,3,3));
	/* ================================================== */
    }
    
    
    
    /**
     * initializes the Components
     */
    private void initComponents()
    {
        this.comment = new JTextArea();
    }

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
//		if (listenersActivated )
//			this.patientEditPanel.setModified(true);
	}
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
	}
	
	/**
	 * enables the panel to be edited
	 * @param editable
	 */
	private void setEditable(boolean editable) {
		this.comment.setEditable(editable);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getComponentsForFocus()
	 */
	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		List<Component> list = new ArrayList<Component>();
		/* ------------------------------------------------------- */
		list.add(comment);
		/* ------------------------------------------------------- */
		return list;
		/* ====================================================== */
	}
}
