/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.contactpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.ContactEditDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.EMailField;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientPhone;
import lu.tudor.santec.gecamed.patient.gui.simpleview.OverviewPanel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ContactPhonePanel.java,v $
 * <br>Revision 1.7  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2010-10-19 14:37:15  troth
 * <br>rename class SimpleViewPanel in OverviewPanel
 * <br>
 * <br>Revision 1.5  2010-03-12 14:12:56  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-05-05 14:35:54  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-04-30 13:09:51  hermen
 * <br>added sidebar
 * <br>
 * <br>Revision 1.1  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 *
 */
public class ContactPhonePanel extends HeaderedPanel implements KeyListener, IContactDataPanel
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ========================================================

        private EMailField email;
        private JTextField phoenMobile;
        private JTextField fax;
        private JTextField phoneWork;
        private JTextField phonePrivate;
        HashMap<String, PatientPhone> phones = new HashMap<String, PatientPhone>();
        private ContactEditDialog contactEditDialog;
	private boolean listenersActivated;
	private JPanel mainPanel;
	private CellConstraints cc;

    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public ContactPhonePanel(ContactEditDialog contactEditDialog)
    {
    	this.setOpaque(false);
    	this.contactEditDialog = contactEditDialog;
        this.buildPanel();
    }

    //~ Methods ================================================================

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient)
     */
    @SuppressWarnings("unchecked")
    public void getContact(Contact contact) {
        	contact.setPhonePrivate(this.phonePrivate.getText());
        	contact.setPhoneMobile(this.phoenMobile.getText());
        	contact.setPhoneWork(this.phoneWork.getText());
        	contact.setFax(this.fax.getText());    	
        	contact.setEmail(this.email.getText());
    }

    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#setPatient(lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient, boolean)
     */
    public void setContact(Contact contact, boolean editable)
    {
    	
    	setEditable(editable);
    	
    	this.listenersActivated = false;

     	this.phonePrivate.setText(contact.getPhonePrivate() != null ? contact.getPhonePrivate() : "");
    	this.phoenMobile.setText(contact.getPhoneMobile() != null ? contact.getPhoneMobile() : "");
    	this.phoneWork.setText(contact.getPhoneWork() != null ? contact.getPhoneWork() : "");
    	this.fax.setText(contact.getFax() != null ? contact.getFax() : "");
        this.email.setText(contact.getEmail() != null ? contact.getEmail() : "");
        
        this.listenersActivated = true;
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel() {
    	/* ================================================== */
    	this.setHeader(Translatrix.getTranslationString("pm.contact")+":");
//    	this.setHeaderIcon(IconFetcher.getMediumIcon(AddressbookModule.class, AddressbookModule.ICON_PHONE));
    	
    	this.enableAlpha(true);
    	this.cc = new CellConstraints();
    	
        initComponents();
        buildViewPanel();
        
        this.setLayout(new BorderLayout());
        this.add(mainPanel, BorderLayout.CENTER);
     
    }


    /**
     * build the gui of the panel
     */
    private void buildViewPanel() {
    	/* ================================================== */
    	
    	this.mainPanel = new JPanel(new FormLayout(
    										// cols
    										"3dlu," +
    										"right:50dlu," +
    										"5dlu," +
    										
    										"fill:90dlu," +
    										"fill:pref:grow",
    										// rows
    										"3dlu," +
    										"fill:pref," +
    										"center:5dlu," + // separator
    										"3dlu," +
    										
    										"fill:pref," +
    										"3dlu," +
    										"fill:pref," +
    										"center:5dlu," + // separator
    										"3dlu," +
    										"fill:pref," +
    										"3dlu," +
    										"fill:pref," +
    										"3dlu"));
    	mainPanel.setOpaque(false);
    	/* ------------------------------------------------------- */
    	JLabel telLabel    = OverviewPanel.createLabel("pm.phoneShort");
    	JLabel mobLabel    = OverviewPanel.createLabel("pm.cellular");
    	JLabel officeLabel = OverviewPanel.createLabel("pm.office");
    	JLabel faxLabel    = OverviewPanel.createLabel("pm.fax");
    	JLabel mailLabel   = OverviewPanel.createLabel("pm.mail");
    	
    	/* ------------------------------------------------------- */
    	// place the labels
    	mainPanel.add(telLabel, 		cc.xy(2, 2));
    	mainPanel.add(new JSeparator(), cc.xyw(2, 3, 3));
    	
    	mainPanel.add(mobLabel,         cc.xy(2, 5));
    	mainPanel.add(officeLabel, 		cc.xy(2, 7));
    	
    	mainPanel.add(new JSeparator(), cc.xyw(2, 8, 3));
    	mainPanel.add(faxLabel, 		cc.xy(2, 10));
    	mainPanel.add(mailLabel, 		cc.xy(2, 12));
    	/* ------------------------------------------------------- */
    	// place the fields
    	
    	mainPanel.add(this.phonePrivate,    cc.xy(4, 2));
    	mainPanel.add(this.phoenMobile, cc.xy(4, 5));
    	mainPanel.add(this.phoneWork,   cc.xy(4, 7));
    	mainPanel.add(this.fax,      cc.xy(4, 10));
    	mainPanel.add(this.email,   cc.xy(4, 12));
		/* ================================================== */
    }
    
    
    
    /**
     * initializes the Components
     */
    private void initComponents()
    {
        this.phonePrivate = new LimitTextField(30);
        this.phonePrivate.addKeyListener(this);
        this.phoenMobile = new LimitTextField(30);
        this.phoenMobile.addKeyListener(this);
        this.phoneWork = new LimitTextField(30);
        this.phoneWork.addKeyListener(this);
        this.fax = new LimitTextField(30);
        this.fax.addKeyListener(this);
        this.email = new EMailField();
        this.email.addKeyListener(this);
    }

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
//		if (listenersActivated )
//			this.patientEditPanel.setModified(true);
	}
	public void keyPressed(KeyEvent e) {
	}
	public void keyReleased(KeyEvent e) {
	}
	
	/**
	 * enables the panel to be edited
	 * @param editable
	 */
	private void setEditable(boolean editable) {
		this.phonePrivate.setEditable(editable);
        	this.phoenMobile.setEditable(editable);
        	this.phoneWork.setEditable(editable);
        	this.fax.setEditable(editable);
        	this.email.setEditable(editable);
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.patient.gui.administrative.IPatientDataPanel#getComponentsForFocus()
	 */
	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		List<Component> list = new ArrayList<Component>();
		/* ------------------------------------------------------- */
		list.add(phonePrivate);
		list.add(phoenMobile);
		list.add(phoneWork);
		list.add(fax);
		list.add(email);
		/* ------------------------------------------------------- */
		return list;
		/* ====================================================== */
	}
}
