/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;

public class ContactListRenderer extends LineColorCellRenderer{

    private static final long serialVersionUID = 1L;
    private ContactTableModel model;
    
    
    private int lineHeight = 35;
    private int borderHeight = 14;
    
    private TitledMatteBorder charBreakBorder = new TitledMatteBorder(borderHeight, "", new Color (140,180,241));
    private JTextArea multilineRenderer = new JTextArea();
    private JTable table;
    private Font font = new JLabel().getFont();
    private Font fontBold = font.deriveFont(Font.BOLD);

    public ContactListRenderer(JTable table, ContactTableModel model) {
	this.model = model;
	this.table = table;
	multilineRenderer.setFont (new Font (getFont().getName(), Font.PLAIN, 10));	
	multilineRenderer.setLineWrap(true);
	multilineRenderer.setWrapStyleWord(true);
    }
    
    /* (non-Javadoc)
     * @see lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    @Override
    public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {
	if (p_Column == 0 || p_Column == 3) {
	    JLabel c =  (JLabel) super.getTableCellRendererComponent(p_Table, value, p_IsSelected,
		    hasFocus, p_Row, p_Column);
	    if (p_Column == 0) {
		c.setFont(fontBold);
	    } else {
		c.setFont(font);
	    }
	    if (model.isCharBreak(p_Row)) {
		    if (p_Column == 0) {
			charBreakBorder.setTitle(model.getCharAtRow(p_Row));
		    } else {
			charBreakBorder.setTitle("");
		    }
		    c.setBorder(charBreakBorder);
		    if (table.getRowHeight(p_Row) < lineHeight+borderHeight)
			table.setRowHeight(p_Row, lineHeight+borderHeight);
		} else { 
		    c.setBorder(null);
		    if (table.getRowHeight(p_Row) < lineHeight)
			table.setRowHeight(p_Row, lineHeight);
		}
		return c;
	} else {
	    Color	l_Background;
		
	    l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
										   GECAMedColors.c_EvenLineBackground;
	    if (p_IsSelected) 
		multilineRenderer.setBackground(p_Table.getSelectionBackground());
            else 
        	multilineRenderer.setBackground(l_Background);
	    	multilineRenderer.setText((String)value);
	    
	    if (model.isCharBreak(p_Row)) {
		    charBreakBorder.setTitle("");
		    multilineRenderer.setBorder(charBreakBorder);
		} else { 
		    multilineRenderer.setBorder(null);
		}
	    return multilineRenderer;
	}
	
	
    }

    
    
}
