/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.list;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.i18n.Translatrix;

public class ContactSearchDialog extends GECAMedBaseDialog implements ActionListener, IContactListener {
    
    private static final long serialVersionUID = 1L;

    private static List<Contact> contact;

    private static ContactSearchDialog contactSearchDialog;

    private ContactTablePanel tablePanel;

    private ContactSearchDialog() {
	super(Translatrix.getTranslationString("Addressbook.findContact"), true);
	
	JPanel p = new JPanel(new BorderLayout());
	p.setOpaque(false);
	p.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	
	tablePanel = new ContactTablePanel();
	this.tablePanel.addContactListener(this);
	
	p.add(tablePanel.getSearchComponent(), BorderLayout.NORTH);
	p.add(tablePanel, BorderLayout.CENTER);
	
	this.addMainPanel(p);
	
	this.enableCancelKeyMapping(true);
	
	this.cancelButton.addActionListener(this);
	this.okButton.addActionListener(this);
	this.setSize(800,600);
	
	contactSearchDialog = this;
    }
    
	public static List<Contact> showDialog(String dialogTitle, String search, String type, boolean multiSelect) {
	    if (contactSearchDialog == null)
	    	new ContactSearchDialog();
	    
	    if (multiSelect)
	    	 contactSearchDialog.tablePanel.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	    else contactSearchDialog.tablePanel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	    
	    contact = null;
	    contactSearchDialog.setTitle(dialogTitle);
	    contactSearchDialog.tablePanel.fillTypeBox();
	    contactSearchDialog.tablePanel.setSearch(search, type);
	    contactSearchDialog.setLocationRelativeTo(MainFrame.getInstance());
	    contactSearchDialog.setVisible(true);
	    return contact;
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.cancelButton)) {
			contact = null;
		} else if (e.getSource().equals(this.okButton)) {
		    	contact = tablePanel.getContacts();
		}
		this.setVisible(false);
	}

	public void contactChanged(Contact con) {
	}

	public void contactClicked(Contact con) {
	    contact = new ArrayList<Contact>(1);
	    contact.add(con);
	    this.setVisible(false);
	}
}
