/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.list;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Tablemodel for the addressbooks contacts
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: ContactTableModel.java,v $
 * <br>Revision 1.7  2010-08-12 08:01:48  hermen
 * <br>fixed #595: Full contact list reload after single contact modification
 * <br>
 * <br>Revision 1.6  2009-01-14 14:30:43  hermen
 * <br>added opening of maps to show address
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-05-08 14:04:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-05-08 09:02:17  hermen
 * <br>changed formatting
 * <br>
 * <br>Revision 1.2  2008-05-06 14:29:13  hermen
 * <br>updated javadoc
 * <br>
 *
 */
public class ContactTableModel extends AbstractTableModel
{
    //~ Static fields/initializers =========================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ====================================================

    @SuppressWarnings("unchecked")
    protected Class[] columnClasses = new Class[] {
    		 String.class,
    		 String.class,
    		 String.class,
    		 String.class,
    		 String.class
        };
    
    protected String[] columnNames = {
    		Translatrix.getTranslationString("Addressbook.name"), 
    		Translatrix.getTranslationString("Addressbook.addresses"), 
    		Translatrix.getTranslationString("Addressbook.phones"),
    		Translatrix.getTranslationString("Addressbook.MedPres"),
    		Translatrix.getTranslationString("Addressbook.type") 
        };
    
    protected ArrayList<Contact> contacts = new ArrayList<Contact>();

    //~ Constructors =======================================================

    
    /**
     * set the Collection<Contact> contacts containing 
     * the contacts to be shown
     * @param contacts
     */
	public void setContacts(Collection<Contact> contacts) {
    	this.contacts = new ArrayList<Contact>(contacts);
     	fireTableDataChanged();
    }

    //~ Methods ============================================================

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int row, int column)
    {
        return false;
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    @SuppressWarnings("unchecked")
	public Class getColumnClass(int col)
    {
        return columnClasses[col];
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount()
    {
        return columnNames.length;
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(int col)
    {
        return "<html><b>" + columnNames[col] ;
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount()
    {
        return contacts.size();
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    public Object getValueAt(int row, int col)
    {
    	
        try {
			Contact contact = contacts.get(row);
			switch (col) {
			case 0:
			    return contact.toNameString();
			case 1:
			    return contact.toAddressString();
			case 2:
			    return contact.toPhoneString();
			case 3:
			    return contact.getMedpres();
			case 4:
			    return contact.getContactType();
			}
		} catch (Exception e) {
		}
        return null;
    }

    /**
     * returns the Contact for the specified row
     * @param row
     * @return
     */
    public Contact getContactforRow(int row) {
    	try {
    		return this.contacts.get(row);			
		} catch (Exception e) {
			return null;
		}
    }
    
    /**
     * returns the row for the specified Contact
     * @param id
     * @return
     */
    public int getRowForContact(Contact c) {
    	for (int i = 0; i < contacts.size(); i++) {
			if (contacts.get(i).equals(c))
				return i;
		}
    	return 0;
    }
    
    public boolean isCharBreak(int row) {
	if (row<1)
	    return true;
	try {
		/* --------------------------------------------- */
		char c1 = contacts.get(row-1).getName().charAt(0);
		char c2 = contacts.get(row).getName().charAt(0);
		if (c1 == c2)
			return false;
		/* --------------------------------------------- */
	} catch (Exception e) {
	}
	return true;
    }
    
    public String getCharAtRow(int row) {
		try {
		    return contacts.get(row).getName().substring(0,1).toUpperCase();
		} catch (Exception e) {
		    return "" ;
		}
    }

    public void updateContact(Contact contact) {
	for (int i = 0; i < contacts.size(); i++) {
	    Contact c = contacts.get(i);
	    if (c.equals(contact)) {
		fireTableRowsUpdated(i, i);
		return;
	    }  
	}
    }
    
}
