/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Calendars can be selected or deselected. This bean is just to store
 * the current selection per user.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 17.01.2008
 * 14:54:35
 *
 *
 * @version
 * <br>$Log: UserCalendarSelection.java,v $
 * <br>Revision 1.4  2010-07-08 08:24:20  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
@javax.persistence.NamedQueries
({
	@NamedQuery(name=UserCalendarSelection.FIND_ALL_USER_CALENDAR_SELECTIONS_BY_USER,
			query="SELECT Object(o) FROM UserCalendarSelection o " +
					"WHERE o.userId = :userId"),
	@NamedQuery(name=UserCalendarSelection.FIND_ALL_USER_CALENDAR_SELECTIONS_BY_USER_AND_CALENDAR,
			query="SELECT Object(o) FROM UserCalendarSelection o " +
					"WHERE o.userId = :userId AND o.calendar = :calendar")
})

@Entity
@Table(name = "rel_user_calendar_selection", schema = "agenda")
public class UserCalendarSelection extends GECAMedEntityBean implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final String FIND_ALL_USER_CALENDAR_SELECTIONS_BY_USER = "findAllUserCalendarSelectionByUser";
	public static final String FIND_ALL_USER_CALENDAR_SELECTIONS_BY_USER_AND_CALENDAR = "findAllUserCalendarSelectionByUserAndCalendar";

	private Integer userId;
	private AgendaCalendar calendar;
	
	public UserCalendarSelection() {
	}
	
	public UserCalendarSelection(Integer userId, AgendaCalendar calendar) {
		this.userId = userId;
		this.calendar = calendar;
	}
	
	/**
	 * @return the calendar
	 */
    @ManyToOne(fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "calendar_id")
	public AgendaCalendar getCalendar() {
		return calendar;
	}
	/**
	 * @param calendar the calendar to set
	 */
	public void setCalendar(AgendaCalendar calendar) {
		this.calendar = calendar;
	}
	/**
	 * @return the userId
	 */
	@Column(name = "user_id")
	public Integer getUserId() {
		return userId;
	}
	/**
	 * @param userId the userId to set
	 */
	public void setUserId(Integer userId) {
		this.userId = userId;
	}
	
}
