/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
///**
// * @author Martin Heinemann martin.heinemann@tudor.lu
// *
// *
// *
// * @version
// * <br>$Log: AppointmentSearchEntity.java,v $
// * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
// * <br>fixed copyrights
// * <br>
// * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
// * <br>code cleanup and java doc
// * <br>
// * <br>Revision 1.3  2007/08/22 11:59:53  heinemann
// * <br>*** empty log message ***
// * <br>
// * <br>Revision 1.2  2007/08/09 14:10:34  heinemann
// * <br>*** empty log message ***
// * <br>
// * <br>Revision 1.1  2007/07/16 09:12:45  heinemann
// * <br>*** empty log message ***
// * <br>
// *   
// */
//package lu.tudor.santec.gecamed.agenda.ejb.session.helper;
//
//import java.io.Serializable;
//import java.util.ArrayList;
//import java.util.Calendar;
//import java.util.List;
//
///**
// * Data transfer class between AppointmentManagerBean and AppointmenRuleBean
// * 
// * 
// * @author martin.heinemann@tudor.lu
// * 10.07.2007
// * 10:27:33
// *
// *
// * @version
// * <br>$Log: AppointmentSearchEntity.java,v $
// * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
// * <br>fixed copyrights
// * <br>
// * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
// * <br>code cleanup and java doc
// * <br>
// * <br>Revision 1.3  2007/08/22 11:59:53  heinemann
// * <br>*** empty log message ***
// * <br>
// * <br>Revision 1.2  2007/08/09 14:10:34  heinemann
// * <br>*** empty log message ***
// * <br>
// * <br>Revision 1.1  2007/07/16 09:12:45  heinemann
// * <br>*** empty log message ***
// * <br>
// *   
// */
//public class AppointmentSearchEntity implements Serializable {
//
//	/**
//	 * 
//	 */
//	private static final long serialVersionUID = 1L;
//	
//	
//	private Integer age;
//	private Boolean children;
//	private Boolean employed;
//	private Boolean retired;
//	
//	private List<TimeInterval> intervals = new ArrayList<TimeInterval>(0);
//	
//	/**
//	 * @param age
//	 * @param children
//	 * @param employed
//	 * @param retired
//	 */
//	public AppointmentSearchEntity(Integer age, Boolean children, Boolean employed, Boolean retired) {
//		/* ================================================== */
//		this.age = age;
//		this.children = children;
//		this.employed = employed;
//		this.retired = retired;
//		/* ------------------------------------------------------- */
//		// create a 24h interval for each day of week
//		for (int i = Calendar.SUNDAY; i <= Calendar.SATURDAY; i++) {
//			/* ------------------------------------------------------- */
//			this.intervals.add(new TimeInterval(0, 2359,i));
//			/* ------------------------------------------------------- */
//		}
//		/* ================================================== */
//	}
//
//	/**
//	 * @return the serialVersionUID
//	 */
//	public static long getSerialVersionUID() {
//		return serialVersionUID;
//	}
//
//	/**
//	 * @return the age
//	 */
//	public Integer getAge() {
//		return age;
//	}
//
//	/**
//	 * @return the children
//	 */
//	public Boolean getChildren() {
//		return children;
//	}
//
//	/**
//	 * @return the employed
//	 */
//	public Boolean getEmployed() {
//		return employed;
//	}
//
//	/**
//	 * @return the intervals
//	 */
//	public List<TimeInterval> getIntervals() {
//		return intervals;
//	}
//
//	/**
//	 * @return the retired
//	 */
//	public Boolean getRetired() {
//		return retired;
//	}
//
//	/**
//	 * @param intervals the intervals to set
//	 */
//	public void setIntervals(List<TimeInterval> intervals) {
//		this.intervals = intervals;
//	}
//	
//	
//	public void excludeInterval(TimeInterval interval) {
//		/* ================================================== */
//		excludeInterval(interval, false);
//		/* ================================================== */
//	}
//	
//	/**
//	 * The strategie of the rule engine is, to add timeintervals
//	 * that must be excluded from the proposed timeinterval.
//	 * @param interval
//	 * @return
//	 */
//	public void excludeInterval(TimeInterval interval, boolean forAllDays) {
//		/* ================================================== */
//		
//		if (forAllDays) {
//			/* ------------------------------------------------------- */
//			for (int i = Calendar.SUNDAY; i <= Calendar.SATURDAY; i++) {
//				TimeInterval ti = new TimeInterval(interval);
//				ti.setDayOfWeek(i);
//				applyInterval(ti);
//			}
//			/* ------------------------------------------------------- */
//		} else
//			applyInterval(interval);
//		/* ================================================== */
//	}
//	
//	
//	/**
//	 * @param interval
//	 */
//	private void applyInterval(TimeInterval interval) {
//		/* ================================================== */
//		int startNew = interval.getStarttime();
//		int endNew   = interval.getEndtime();
//		/* ------------------------------------------------------- */
//		while (true) {
//			/* ------------------------------------------------------- */
//			// find the according day of week
//			for (TimeInterval ti : intervals) {
//				if (ti.getDayOfWeek() == interval.getDayOfWeek()) {
//					/* ------------------------------------------------------- */
//					int startOld = ti.getStarttime();
//					int endOld   = ti.getEndtime();
//					// new one cuts the old in two pieces | new is during the old one
//					if (startOld < startNew && endOld > endNew) {
//						/* ------------------------------------------------------- */
//						ti.setStarttime(startOld);
//						// ti.setEndtime(startNew - 1);
//						ti.setEndtime(startNew);
//						// --
//						// interval.setStarttime(endNew + 1);
//						interval.setStarttime(endNew);
//						interval.setEndtime(endOld);
//						// --- add
//						this.intervals.add(interval);
////						System.out.print("adding " + interval + "-- old interval " + ti);
////						System.out.println();
//						break;
//						/* ------------------------------------------------------- */
//					}
//					/* ------------------------------------------------------- */
//					// new cuts at least the rest of the old
//					if (startOld < startNew && endOld <= endNew && endOld > startNew) {
//						/* ------------------------------------------------------- */
//						ti.setStarttime(startOld);
//						// ti.setEndtime(startNew - 1);
//						ti.setEndtime(startNew);
////						System.out.println("cutting " + ti);
//						break;
//						/* ------------------------------------------------------- */
//					}
//					/* ------------------------------------------------------- */
//					// new cuts the head of old
//					if (startOld  >= startNew && endOld > endNew) {
//						/* ------------------------------------------------------- */
//						// ti.setStarttime(endNew + 1);
//						ti.setStarttime(endNew);
//						ti.setEndtime(endOld);
////						System.out.print("cutting " + ti);
//						break;
//						/* ------------------------------------------------------- */
//					}
//					/* ------------------------------------------------------- */
//					// new covers old -> remove
//					if (startOld >= startNew && endOld <= endNew) {
//						/* ------------------------------------------------------- */
//						this.intervals.remove(ti);
////						System.out.println("removing " + ti);
//						break;
//						/* ------------------------------------------------------- */
//					}
//					/* ------------------------------------------------------- */
//				}
//			}
//			// exit the while
//			break;
//			/* ------------------------------------------------------- */
//		}
//		/* ================================================== */
//	}
//	
//
//}
