/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/

package lu.tudor.santec.gecamed.agenda.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.AppointmentType;
import lu.tudor.santec.gecamed.agenda.ejb.session.beans.AppointmentManagerBean;
import lu.tudor.santec.gecamed.agenda.ejb.session.interfaces.AppointmentManager;
import lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype.AppointmentTypeTableCellDurationEditor;
import lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype.AppointmentTypeTableCellIconEditor;
import lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype.AppointmentTypeTableCellRenderer;
import lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype.AppointmentTypesTableModel;
import lu.tudor.santec.gecamed.agenda.utils.AgendaAdminSettingsConstants;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.renderer.TranslatrixComboboxRenderer;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.patient.gui.settings.ConsultationEntryConfig;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
*
* @author nmac / jhermen
*/

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaAdminSettingsPlugin.java,v $
 * <br>Revision 1.22  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.21  2013-07-15 06:18:36  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.20  2013-02-19 12:07:34  ferring
 * <br>GECAMedLists changed. Will now automatically load list of all beans
 * <br>
 * <br>Revision 1.19  2011-10-04 12:13:32  troth
 * <br>fix Ticket #892 - Patient matricule and treatment type automatically added to agenda entry description
 * <br>
 */
public class AgendaAdminSettingsPlugin extends SettingsPlugin implements AgendaAdminSettingsConstants, ComponentListener{
	private static final long serialVersionUID = 1L;

	/**
	 * static logger for this class
	 */
	private static Logger  logger = Logger
			.getLogger(AgendaAdminSettingsPlugin.class.getName());
	
	
	/**
	 * Hour fregmentation. 60, 30, 20, 15, 10, 5 minutes 
	 */
	public static final int FRAG_HOUR    = 60;
	public static final int FRAG_HALF    = 30;
	public static final int FRAG_THIRD   = 20;
	public static final int FRAG_QUARTER = 15;
	public static final int FRAG_SIXTHT  = 10;
	public static final int FRAG_TWELFTH = 5;
	
	private Integer[] fragValues = {
					FRAG_HOUR,
					FRAG_HALF,
					FRAG_THIRD,
					FRAG_QUARTER,
					FRAG_SIXTHT,
					FRAG_TWELFTH
	};
	
	private CellConstraints cc;

	private AppointmentManager apManager;

	private JPanel generalTypesPanel;

	private JPanel bgTypesPanel;

	private JPanel blockTypesPanel;

	private HashMap<Integer, AppointmentTypesTableModel> models = new HashMap<Integer, AppointmentTypesTableModel>();

	private JPanel fragPanel;

	private JLabel fragLabel;

	private JComboBox fragBox;
	
	/**
	 * Auto Description global setting for the Appointment
	 */
	private JPanel autoDescriptionPanel;
	
	private JCheckBox autoDescCheckBoxMatr;
	
	private JCheckBox autoDescCheckBoxType;
	
	private JCheckBox autoDescCheckBoxID;

	private JPanel doctenaPanel;

	private JLabel doctenaftpserverLabel;

	private JTextField doctenaftpserverField;

	private JLabel doctenaftpportLabel;

	private IntegerField doctenaftpportField;

	private JLabel doctenainboxLabel;

	private JTextField doctenainboxField;

	private JLabel doctenadoneboxLabel;

	private JTextField doctenadoneboxField;

	private JLabel doctenaerrorboxLabel;

	private JTextField doctenaerrorboxField;

	private JLabel doctenasyncmonthLabel;

	private JLabel doctenasyncintervalLabel;

	private IntegerField doctenasyncintervalField;

	private IntegerField doctenasyncmonthField;

	private JLabel doctenasyncactiveLabel;

	private JCheckBox doctenasyncactiveField;

	private JPanel generalPanel;

	private JCheckBox jmsEnabledBox;
	
	
//	private JCheckBox SMSEnabled;
//
//	private JPanel SMSPanel;
//	
//	private JTextField SMSDaysCheckField;
//	
//	private JLabel SMSEnabledLabel;
//	
//	private JLabel SMSDaysCheckLabel;
	//private AppointmentTypesTableModel typesModel;
	


	/**
	 * 
	 */
	public AgendaAdminSettingsPlugin() {
		/* ================================================== */
		super(NAME);
		this.setStationaryValues();
		buildPanel();
		/* ================================================== */
	}

	/**
	 * @param p_Name
	 */
	public AgendaAdminSettingsPlugin(String p_Name) {
		/* ================================================== */
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
		
		
		/* ================================================== */
	}

	/**
	 * 
	 */
	private void buildPanel() {
		/* ================================================== */
		try {
			apManager = (AppointmentManager) ManagerFactory
			.getRemote(AppointmentManagerBean.class);
		} catch (Exception e) {
			logger.log(Level.WARN, "error getting APPOINTMENTMANAGER" , e);
		}
		
		this.cc = new CellConstraints();

        
		setLabel(Translatrix.getTranslationString("Agenda.Agenda"));
		
		generalTypesPanel = createTypesPanel(Translatrix.getTranslationString("Agenda.generalTypes"), AppointmentType.GENERAL);
		
		
		addSubPanel(generalTypesPanel);
		
		bgTypesPanel = createTypesPanel(Translatrix.getTranslationString("Agenda.bgTypes"), AppointmentType.BACKGROUND);
		addSubPanel(bgTypesPanel);
		
		blockTypesPanel = createTypesPanel(Translatrix.getTranslationString("Agenda.blockTypes"), AppointmentType.BLOCK_PERIOD);
		addSubPanel(blockTypesPanel);
		 
		this.addComponentListener(this);
		
		/* ------------------------------------------------------- */
		// hour fragmentation
		/* ------------------------------------------------------- */
		this.fragPanel = createSubPanel(Translatrix.getTranslationString("Agenda.settings.hourfragmentation"));
		this.fragPanel.setLayout(new FormLayout("pref:grow, 3dlu, 70dlu", "top:pref, 3dlu, pref"));

		this.fragLabel = new JLabel(Translatrix.getTranslationString("Agenda.settings.hourfragmentation.explain"));
		this.fragPanel.add(fragLabel, cc.xy(1,1));

		this.fragBox = new JComboBox(fragValues);
		this.fragPanel.add(fragBox, cc.xy(3,1));
		
		fragBox.setRenderer(new TranslatrixComboboxRenderer("Agenda.settings.hourfragmentation"));
		
		addSubPanel(fragPanel);
		
		/* ------------------------------------------------------- */
		// autoDescriptionPanel
		/* ------------------------------------------------------- */
		this.autoDescriptionPanel = createSubPanel(Translatrix.getTranslationString("Agenda.settings.autoDescription.title"));
		this.autoDescriptionPanel.setLayout(new FormLayout("3dlu, pref:grow, 3dlu", "top:pref, 3dlu, pref, pref"));

		this.autoDescCheckBoxMatr = new JCheckBox(Translatrix.getTranslationString("Agenda.settings.autoDescription.matricule"));
		this.autoDescriptionPanel.add(autoDescCheckBoxMatr, cc.xy(2,1));

		this.autoDescCheckBoxType = new JCheckBox(Translatrix.getTranslationString("Agenda.settings.autoDescription.type"));
		this.autoDescriptionPanel.add(autoDescCheckBoxType, cc.xy(2,3));
		
		this.autoDescCheckBoxID = new JCheckBox("Display ID");
		this.autoDescriptionPanel.add(autoDescCheckBoxID, cc.xy(2,4));
		
		addSubPanel(autoDescriptionPanel);
		
		/* ------------------------------------------------------- */
		// doctena
		/* ------------------------------------------------------- */
		this.doctenaPanel = createSubPanel(Translatrix.getTranslationString("calendar.doctena"));
		this.doctenaPanel.setLayout(new FormLayout(
				"3dlu, pref, 3dlu, pref:grow, 3dlu", 
				"3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu"));
		
		int row = 0;
		
		this.doctenasyncactiveLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.syncactive"));
		this.doctenasyncactiveLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncactiveTip"));
		this.doctenaPanel.add(doctenasyncactiveLabel, cc.xy(2,row+=2));
		this.doctenasyncactiveField = new JCheckBox();
		this.doctenasyncactiveField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncactiveTip"));
		this.doctenasyncactiveField.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				enableDoctena(doctenasyncactiveField.isSelected());
			}
		});
		this.doctenaPanel.add(doctenasyncactiveField, cc.xy(4,row));
		
		this.doctenasyncintervalLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.syncinterval"));
		this.doctenasyncintervalLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncintervalTip"));
		this.doctenaPanel.add(doctenasyncintervalLabel, cc.xy(2,row+=2));
		this.doctenasyncintervalField = new IntegerField();
		this.doctenasyncintervalField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncintervalTip"));
		this.doctenaPanel.add(doctenasyncintervalField, cc.xy(4,row));
		
		this.doctenasyncmonthLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.syncmonth"));
		this.doctenasyncmonthLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncmonthTip"));
		this.doctenaPanel.add(doctenasyncmonthLabel, cc.xy(2,row+=2));
		this.doctenasyncmonthField = new IntegerField();
		this.doctenasyncmonthField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.syncmonthTip"));
		this.doctenaPanel.add(doctenasyncmonthField, cc.xy(4,row));
		
		this.doctenaftpserverLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.ftpserver"));
		this.doctenaftpserverLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpserverTip"));
		this.doctenaPanel.add(doctenaftpserverLabel, cc.xy(2,row+=2));
		this.doctenaftpserverField = new JTextField();
		this.doctenaftpserverField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpserverTip"));
		this.doctenaPanel.add(doctenaftpserverField, cc.xy(4,row));
		
		this.doctenaftpportLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.ftpport"));
		this.doctenaftpportLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpportTip"));
		this.doctenaPanel.add(this.doctenaftpportLabel, cc.xy(2,row+=2));
		this.doctenaftpportField = new IntegerField();
		this.doctenaftpportField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpportTip"));
		this.doctenaPanel.add(this.doctenaftpportField, cc.xy(4,row));
		
		this.doctenainboxLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.ftpinbox"));
		this.doctenainboxLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpinboxTip"));
		this.doctenaPanel.add(this.doctenainboxLabel, cc.xy(2,row+=2));
		this.doctenainboxField = new JTextField();
		this.doctenainboxField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpinboxTip"));
		this.doctenaPanel.add(this.doctenainboxField, cc.xy(4,row));
		
		this.doctenadoneboxLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.ftpdonebox"));
		this.doctenadoneboxLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpdoneboxTip"));
		this.doctenaPanel.add(this.doctenadoneboxLabel, cc.xy(2,row+=2));
		this.doctenadoneboxField = new JTextField();
		this.doctenadoneboxField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftpdoneboxTip"));
		this.doctenaPanel.add(this.doctenadoneboxField, cc.xy(4,row));
		
		this.doctenaerrorboxLabel = new JLabel(Translatrix.getTranslationString("calendar.doctena.ftperrorbox"));
		this.doctenaerrorboxLabel.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftperrorboxTip"));
		this.doctenaPanel.add(this.doctenaerrorboxLabel, cc.xy(2,row+=2));
		this.doctenaerrorboxField = new JTextField();
		this.doctenaerrorboxField.setToolTipText(Translatrix.getTranslationString("calendar.doctena.ftperrorboxTip"));
		this.doctenaPanel.add(this.doctenaerrorboxField, cc.xy(4,row));
		
		addSubPanel(this.doctenaPanel);
		
//		this.SMSPanel = createSubPanel("SMS");
//		this.SMSPanel.setLayout(new FormLayout(
//				"3dlu, pref, 3dlu, pref:grow, 3dlu", 
//				"3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu"));
//		
//		int row2 = 0;
//		
//		this.SMSEnabledLabel = new JLabel(Translatrix.getTranslationString("Agenda.sms.enabled"));
//		
//		this.SMSPanel.add(SMSEnabledLabel, cc.xy(2,row2+=2));
//		this.SMSEnabled = new JCheckBox();
//		
//	
//	
//	
//		this.SMSEnabled.addActionListener(new ActionListener() {
//			
//			public void actionPerformed(ActionEvent e) {
//				// TODO Auto-generated method stub
//				if(SMSEnabled.isSelected())
//				{
//					SMSDaysCheckField.setEnabled(true);
//				}
//				else
//				{
//					SMSDaysCheckField.setEnabled(false);
//				}
//			}
//		});
//		this.SMSPanel.add(SMSEnabled, cc.xy(4,row2));
//		
//		this.SMSDaysCheckLabel=new JLabel(Translatrix.getTranslationString("Agenda.sms.days"));
//		this.SMSPanel.add(SMSDaysCheckLabel, cc.xy(2,row2+=2));
//		this.SMSDaysCheckField = new JTextField();
//		this.SMSPanel.add(SMSDaysCheckField, cc.xy(4,row2));
//		
//	
//	
//		addSubPanel(this.SMSPanel);
	
		/* ------------------------------------------------------- */
		// generalPanel
		/* ------------------------------------------------------- */
		this.generalPanel = createSubPanel(Translatrix.getTranslationString("Agenda.settings.generalPanel.title"));
		this.generalPanel.setLayout(new FormLayout("3dlu, pref:grow, 3dlu", "top:pref, 3dlu, pref, pref"));

		this.jmsEnabledBox = new JCheckBox(Translatrix.getTranslationString("Agenda.settings.generalPanel.jmsEnabled"));
		this.generalPanel.add(jmsEnabledBox, cc.xy(2,1));

		addSubPanel(generalPanel);
		
		
		
		relocalize();
		/* ------------------------------------------------------- */
// #####################################################

		setIcon(AgendaModule.getIcon(AgendaModule.ICON_AGENDA));
		/* ================================================== */
		
//		if(SMSEnabled.isSelected())
//		{
//			SMSDaysCheckField.setEnabled(true);
//		}
//		else
//		{
//			SMSDaysCheckField.setEnabled(false);
//		}
	}
	
	protected void enableDoctena(boolean enable) {
		doctenaftpserverLabel.setEnabled(enable);

		doctenaftpserverField.setEnabled(enable);
		doctenaftpportLabel.setEnabled(enable);
		doctenaftpportField.setEnabled(enable);
		doctenainboxLabel.setEnabled(enable);
		doctenainboxField.setEnabled(enable);
		doctenadoneboxLabel.setEnabled(enable);
		doctenadoneboxField.setEnabled(enable);
		doctenaerrorboxLabel.setEnabled(enable);
		doctenaerrorboxField.setEnabled(enable);
		doctenasyncmonthLabel.setEnabled(enable);
		doctenasyncintervalLabel.setEnabled(enable);
		doctenasyncintervalField.setEnabled(enable);
		doctenasyncmonthField.setEnabled(enable);
		
	}

	/**
	 * @param title
	 * @param type
	 * @return
	 */
	private JPanel createTypesPanel(String title, final Integer type) {
		/* ================================================== */
		JPanel typesPanel = createSubPanel(title);
		typesPanel.setOpaque(false);
		typesPanel.setLayout(new FormLayout(
				"2dlu, fill:pref:grow, 2dlu,40dlu",
				"2dlu, 40dlu, 40dlu, 2dlu"));
		
		Collection<AppointmentType> types = getGlobalTypes(type);
		
		
		
		final AppointmentTypesTableModel typesModel = new AppointmentTypesTableModel(types, true);
		
		models .put(type, typesModel);
		
		final JButton addButton = new JButton();
		addButton.setIcon(GECAMedModule.getMediumIcon(GECAMedModule.ADD_LINE));
    
        
        final JButton removeButton = new JButton();
        removeButton.setIcon(GECAMedModule.getMediumIcon(GECAMedModule.REMOVE_LINE));
        
		
		final JTable jt = new JTable(typesModel);
		jt.getTableHeader().setReorderingAllowed(false);
		AppointmentTypeTableCellRenderer renderer = new AppointmentTypeTableCellRenderer();
		AppointmentTypeTableCellIconEditor ie = new AppointmentTypeTableCellIconEditor();
		AppointmentTypeTableCellDurationEditor de = new AppointmentTypeTableCellDurationEditor();
		jt.getColumnModel().getColumn(0).setCellRenderer(renderer);
		jt.getColumnModel().getColumn(1).setMaxWidth(50);
		jt.getColumnModel().getColumn(1).setCellRenderer(renderer);
		jt.getColumnModel().getColumn(1).setCellEditor(de);
		jt.getColumnModel().getColumn(2).setMaxWidth(50);
		jt.getColumnModel().getColumn(2).setCellRenderer(renderer);
		jt.getColumnModel().getColumn(2).setCellEditor(ie);
		JScrollPane jsp = new JScrollPane(jt);
		jsp.setOpaque(false);
		jsp.getViewport().setOpaque(true);
		jsp.getViewport().setBackground(Color.WHITE);
		jsp.setPreferredSize(new Dimension(50,50));
		
		typesPanel.add(jsp, cc.xywh(2, 2, 2, 2));
		typesPanel.add(addButton,cc.xy(4, 2));
		typesPanel.add(removeButton,cc.xy(4, 3));
		
		final JPopupMenu popup = new JPopupMenu();
		final JMenuItem addItem = new JMenuItem(
				Translatrix.getTranslationString("core.add"), 
				GECAMedModule.getSmallIcon(GECAMedModule.ADD_LINE));
		final JMenuItem deleteItem = new JMenuItem(
				Translatrix.getTranslationString("core.delete"), 
				GECAMedModule.getSmallIcon(GECAMedModule.REMOVE_LINE));

		ActionListener al = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (e.getSource().equals(addItem) || e.getSource().equals(addButton)) {
					AppointmentType at = new AppointmentType();
					at.setName("new Type");
					at.setAppointmentTypeClass(type);
					typesModel.addElement(at);
				} else if (e.getSource().equals(deleteItem) || e.getSource().equals(removeButton)) {
					try {
						AppointmentType at = typesModel.getElement(jt.getSelectedRow());
						if (at != null) {
							if (at.isPersistent()) {
									at.setDeprecated(true);
									apManager.saveAppointmentType(MainFrame.getClientId(), at);
							}			
							typesModel.deleteElement(at);
						}
					} catch (ArrayIndexOutOfBoundsException ae) {
						return;
					} 
					catch (Exception ee) {
						ee.printStackTrace();
					}
				} 
			}
		};
	
		addButton.addActionListener(al);

        removeButton.addActionListener(al);
        
	    addItem.addActionListener(al);
	    popup.add(addItem);
	    deleteItem.addActionListener(al);
	    popup.add(deleteItem);

	    		MouseAdapter ma = new MouseAdapter() {
	    	
			    public void mousePressed(MouseEvent e) {
			        maybeShowPopup(e);
			    }
			
			    public void mouseReleased(MouseEvent e) {
			        maybeShowPopup(e);
			    }
			
			    private void maybeShowPopup(MouseEvent e) {
			        if (e.isPopupTrigger()) {
			        	try {
			        		int row = jt.rowAtPoint(e.getPoint());
			        		jt.setRowSelectionInterval(row, row);
//			        		popup.show(e.getComponent(),
//			        				e.getX(), e.getY());
						} catch (Exception ex) {
						}
						popup.show(e.getComponent(), e.getX(), e.getY());
			        }
			    }
		    }
	    ;
	    jt.addMouseListener(ma);
	    jsp.getViewport().addMouseListener(ma);

		return typesPanel;
		/* ================================================== */
	}

	public void revertToDefaults() {
		/* ================================================== */

		/* ------------------------------------------------------- */
//		this.dayHourStartBox.setDate((Date) getDefault(START_HOUR));
		
		this.fragBox.setSelectedItem(getDefault(HOUR_FRAGMENTATION));
		this.autoDescCheckBoxMatr.setSelected(false);
		this.autoDescCheckBoxType.setSelected(false);
		this.autoDescCheckBoxID.setSelected(false);
		
		
		this.reflectSettings();
		super.revertToDefaults();
		/* ================================================== */
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
		/* ================================================== */
//		setValue(START_HOUR, (Date) this.dayHourStartBox.getDate());
		this.setValue(HOUR_FRAGMENTATION, this.fragBox.getSelectedItem());
		this.setValue(AUTO_DESCRIPTION_MATR, this.autoDescCheckBoxMatr.isSelected());
		this.setValue(AUTO_DESCRIPTION_TYPE, this.autoDescCheckBoxType.isSelected());
		this.setValue(AUTO_DESCRIPTION_ID, this.autoDescCheckBoxID.isSelected());
		
		this.setValue(DOCTENA_SYNC_ACTIVE, this.doctenasyncactiveField.isSelected());
		this.setValue(DOCTENA_SYNC_INTERVAL, this.doctenasyncintervalField.getValue());
		this.setValue(DOCTENA_SYNCMONTHS, this.doctenasyncmonthField.getValue());
		this.setValue(DOCTENA_FTP_SERVER, this.doctenaftpserverField.getText());
		this.setValue(DOCTENA_FTP_PORT, this.doctenaftpportField.getValue());
		this.setValue(DOCTENA_FTP_INBOX, this.doctenainboxField.getText());
		this.setValue(DOCTENA_FTP_DONEBOX, this.doctenadoneboxField.getText());
		this.setValue(DOCTENA_FTP_ERRORBOX, this.doctenaerrorboxField.getText());
		
		this.setValue(JMS_ENABLED, this.jmsEnabledBox.isSelected());
		
//		this.setValue(SMS_ENABLED, this.SMSEnabled.isSelected());
//		this.setValue(SMS_DAYS, this.SMSDaysCheckField.getText());
		
		super.updateSettings();
//		AgendaModule.loadApointmentTypes();
		/* ================================================== */
	}

	public void reflectSettings() {
		/* ================================================== */
		try {
			/* --------------------------------------------- */
			
		this.fragBox.setSelectedItem(this.getValue(HOUR_FRAGMENTATION));
		this.autoDescCheckBoxMatr.setSelected(((Boolean) this.getValue(AUTO_DESCRIPTION_MATR)));
		this.autoDescCheckBoxType.setSelected(((Boolean) this.getValue(AUTO_DESCRIPTION_TYPE)));
		this.autoDescCheckBoxID.setSelected(((Boolean) this.getValue(AUTO_DESCRIPTION_ID)));
		
		this.doctenasyncactiveField.setSelected((Boolean) this.getValue(DOCTENA_SYNC_ACTIVE));
		this.doctenasyncintervalField.setValue((Integer) this.getValue(DOCTENA_SYNC_INTERVAL));
		this.doctenasyncmonthField.setValue((Integer) this.getValue(DOCTENA_SYNCMONTHS));
		this.doctenaftpserverField.setText((String) this.getValue(DOCTENA_FTP_SERVER));
		this.doctenaftpportField.setValue((Integer) this.getValue(DOCTENA_FTP_PORT));
		this.doctenainboxField.setText((String) this.getValue(DOCTENA_FTP_INBOX));
		this.doctenadoneboxField.setText((String) this.getValue(DOCTENA_FTP_DONEBOX));
		this.doctenaerrorboxField.setText((String) this.getValue(DOCTENA_FTP_ERRORBOX));
		enableDoctena(doctenasyncactiveField.isSelected());
		
//		this.SMSDaysCheckField.setText((String) this.getValue(SMS_DAYS));
//		this.SMSEnabled.setSelected((Boolean) this.getValue(SMS_ENABLED));
		
		
		this.jmsEnabledBox.setSelected(((Boolean) this.getValue(JMS_ENABLED)));
		
		super.reflectSettings();
		/* --------------------------------------------- */
		} catch (Exception e) {
			/* --------------------------------------------- */
			e.printStackTrace();
			/* --------------------------------------------- */
		}
		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
//		this.dayHourStartBox.setDate((Date) getValue(START_HOUR));
		/* ================================================== */
	}

	public void relocalize() {
		/* ================================================== */

		super.relocalize();

		setLabel(Translatrix.getTranslationString("Agenda.Agenda"));
		setSubPanelTitle(generalTypesPanel, Translatrix.getTranslationString("Agenda.generalTypes"));
		setSubPanelTitle(bgTypesPanel, Translatrix.getTranslationString("Agenda.bgTypes"));
		setSubPanelTitle(blockTypesPanel, Translatrix.getTranslationString("Agenda.blockTypes"));
		setSubPanelTitle(fragPanel, Translatrix.getTranslationString("Agenda.settings.hourfragmentation"));
		setSubPanelTitle(autoDescriptionPanel, Translatrix.getTranslationString("Agenda.settings.autoDescription.title"));
		this.autoDescCheckBoxMatr.setText(Translatrix.getTranslationString("Agenda.settings.autoDescription.matricule"));
		this.autoDescCheckBoxType.setText(Translatrix.getTranslationString("Agenda.settings.autoDescription.type"));
		this.autoDescCheckBoxID.setText(Translatrix.getTranslationString("Agenda.settings.autoDescription.id"));
		/* ================================================== */
	}

	public void setStationaryValues() {
		/* ================================================== */
//		setStationary(START_HOUR, DateUtil.createDate(Calendar.HOUR_OF_DAY, 8));
		setStationary(HOUR_FRAGMENTATION, FRAG_QUARTER);
		setStationary(CALENDAR_LOCALE,Locale.FRANCE);
		setStationary(AUTO_DESCRIPTION_MATR, false);
		setStationary(AUTO_DESCRIPTION_TYPE, false);
		setStationary(AUTO_DESCRIPTION_ID, false);

		setStationary(DOCTENA_SYNC_ACTIVE, DEFAULT_DOCTENA_SYNC_ACTIVE);
		setStationary(DOCTENA_SYNC_INTERVAL, DEFAULT_DOCTENA_SYNC_INTERVAL);
		setStationary(DOCTENA_SYNCMONTHS, DEFAULT_DOCTENA_SYNCMONTHS);
		setStationary(DOCTENA_FTP_SERVER, DEFAULT_DOCTENA_FTP_SERVER);
		setStationary(DOCTENA_FTP_PORT, DEFAULT_DOCTENA_FTP_PORT);
		setStationary(DOCTENA_FTP_INBOX, DEFAULT_DOCTENA_FTP_INBOX);
		setStationary(DOCTENA_FTP_DONEBOX, DEFAULT_DOCTENA_FTP_DONEBOX);
		setStationary(DOCTENA_FTP_ERRORBOX, DEFAULT_DOCTENA_FTP_ERRORBOX);
		
//		setStationary(SMS_DAYS,DEFAULT_SMS_DAYS);
//		setStationary(SMS_ENABLED, DEFAULT_SMS_ENABLED);
		
		setStationary(JMS_ENABLED, true);
		/* ================================================== */
	}
	
	
	private Collection<AppointmentType> getGlobalTypes(Integer type)
	{
		// get appointment types from GECAMedLists
		List<AppointmentType> loadedApps	= GECAMedLists.getListReference(AppointmentType.class);
		List<AppointmentType> newApps		= new ArrayList<AppointmentType>(loadedApps.size());
		
		
		for (AppointmentType at : loadedApps)
		{
			if (at.getCalendarId() == null && type.equals(at.getAppointmentTypeClass()))
				newApps.add(at);
		}
		return newApps;
	}
	
	
	public void componentHidden(ComponentEvent e) {}
	public void componentMoved(ComponentEvent e) {}
	public void componentResized(ComponentEvent e) {}
	public void componentShown(ComponentEvent e) {
		/* ====================================================== */
		//		 update types
//		AgendaModule.loadApointmentTypes();
		for (Iterator<Integer> iter = models.keySet().iterator(); iter.hasNext();) {
			Integer type = (Integer) iter.next();
			models.get(type).setTypes(getGlobalTypes(type));			
		}
		/* ====================================================== */
	}

	
	
	
}


