/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Calendar;
import java.util.Date;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import lu.tudor.santec.bizcal.views.DayViewPanel;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.views.MonthViewPanel;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.DateTimeChooser;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;
import bizcal.util.DateUtil;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Settingsplugin for user settings of the agenda module.
 * Things to configure: opening times per day. opening times a week. Lunch break. default view
 * amount of entries in the list view, transparency of the grid. 
 * 
 * @author martin.heinemann@tudor.lu
 * @author johannes.hermen@tudor.lu
 * @author nico.mack@tudor.lu
 * 18.01.2008
 * 15:41:23
 *
 *
 * @version
 * <br>$Log: AgendaSettingsPlugin.java,v $
 * <br>Revision 1.22  2012-08-09 14:18:49  troth
 * <br>Ticket #1021 - Unpredictable NAF results and long search delai when no time slot left.
 * <br>
 * <br>Revision 1.21  2012-04-24 14:02:13  troth
 * <br>Remove same warnings.
 * <br>
 * <br>Revision 1.20  2012-01-23 16:05:00  troth
 * <br>Add the old view layout of agenda, now the user can switch between the two layouts old (staircase display) and new (column display).
 * <br>Bug fix in both layouts of the views. Separate the (1)holiday-, (2)office-, (3)background- and (4)normal events in different layers for the order of drawing ((1) - (4) the order of drawing).
 * <br>
 * <br>Revision 1.19  2012-01-18 16:31:25  troth
 * <br>Test: add the old view layout of agenda, now the user can switch between the two layouts old and new.
 * <br>
 * <br>Revision 1.18  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.17  2008-05-26 12:45:04  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.16  2008-05-16 14:18:14  heinemann
 * <br>formlayout fix
 * <br>
 * <br>Revision 1.15  2008-05-13 11:53:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.14  2008-03-28 08:51:34  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.13  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaSettingsPlugin.java,v $
 * <br>Revision 1.22  2012-08-09 14:18:49  troth
 * <br>Ticket #1021 - Unpredictable NAF results and long search delai when no time slot left.
 * <br>
 */
/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaSettingsPlugin.java,v $
 * <br>Revision 1.22  2012-08-09 14:18:49  troth
 * <br>Ticket #1021 - Unpredictable NAF results and long search delai when no time slot left.
 * <br>
 */
/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaSettingsPlugin.java,v $
 * <br>Revision 1.22  2012-08-09 14:18:49  troth
 * <br>Ticket #1021 - Unpredictable NAF results and long search delai when no time slot left.
 * <br>
 */
/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaSettingsPlugin.java,v $
 * <br>Revision 1.22  2012-08-09 14:18:49  troth
 * <br>Ticket #1021 - Unpredictable NAF results and long search delai when no time slot left.
 * <br>
 */
public class AgendaSettingsPlugin extends SettingsPlugin {
	private static final long serialVersionUID = 1L;

	/**
	 * The type of view of the calendar, can be dayview, weekview, monthview or listview
	 */
	public static final String START_VIEW 		= "START_VIEW";
	
	public static final String LIST_VIEW_RECENT = "LIST_VIEW_RECENT";
	
	public static final String LIST_VIEW_PERIOD = "LIST_VIEW_PERIOD";

	public static final String NAME 			= "agendaModuleSettings";

	/**
	 * When the day starts<br/>
	 * Date object!
	 */
	public static final String START_HOUR 		= "START_HOUR";
	/**
	 * When the day stops<br/>
	 * Date object!
	 */
	public static final String STOP_HOUR  		= "STOP_HOUR";

	/**
	 * Integer object
	 */
	public static final String WEEK_DAY_START 	= "WEEK_DAY_START";
	/**
	 * Integer object
	 */
	public static final String WEEK_DAY_STOP  	= "WEEK_DAY_STOP";
	/**
	 * Could be lunch<br/>
	 * Integer value!
	 */
	public static final String DAY_BREAK 	  	= "DAY_BREAK";
	
	
	/**
	 * The alpha value key for the grid
	 */
	public static final String GRID_ALPHA		= "GRID_ALPHA";
	
	public static final String VIEW_LAYOUT 		= "VIEW_LAYOUT"; 
	
	/**
	 * Maximal search period for the Appointment Finder. 
	 */
	public static final String MAX_SEARCH_DAYS 	= "MAX_SEARCH_DAYS";
	
	private JPanel listViewPanel;

	private JComboBox timePeriod;

	private JLabel timePeriodLabel;

	private JCheckBox recentAppointments;
	
	private Integer[] timePeriods = {
			1, 2, 5, 7, 14, 30 
	};
	
	private JPanel generalPanel;

	private JComboBox startViewBox;

	private JLabel startViewLabel;

	private CellConstraints cc;

	private JLabel dayHoursLabel;

	private JLabel dayHourStartLabel;

	private JLabel dayHourStopLabel;

	private DateTimeChooser dayHourStartBox;

	private DateTimeChooser dayHourStopBox;

	private JLabel dayWeekLabel;

	private DateTimeChooser dayWeekStartBox;

	private DateTimeChooser dayWeekStopBox;

	private JLabel dayWeekStartLabel;

	private JLabel dayWeekStopLabel;

	private JLabel dayBreakLabel;

	private DateTimeChooser dayBreakBox;

	private JPanel gridAlphaPanel;

	private JLabel gridAlpaLabel;

	private JSlider gridAlphaSlider;

	// Maximal search period for the Appointment Finder. 
	private JPanel maxSearchPanel;

	private JLabel maxSearchLabel;

	private JTextField maxSearchTextField;

	/**
	 * 
	 */
	public AgendaSettingsPlugin() {
		super(NAME);
		this.setStationaryValues();
		buildPanel();
	}

	/**
	 * @param p_Name
	 */
	public AgendaSettingsPlugin(String p_Name) {
		super(p_Name);
		this.setStationaryValues();
		buildPanel();
	}
	
	private void buildPanel()
	{
		this.cc = new CellConstraints();

		setLabel(Translatrix.getTranslationString("Agenda.Agenda"));

		buildGeneralDayViewPanel();

		addSubPanel(generalPanel);
		
		this.listViewPanel = createSubPanel(Translatrix.getTranslationString("Agenda.listView"));
		this.listViewPanel.setLayout(new FormLayout("3dlu, pref:grow, 3dlu, 30dlu, 3dlu", "3dlu, top:pref, 3dlu"));

		this.timePeriodLabel = new JLabel(Translatrix.getTranslationString("Agenda.listTimePeriods"));
		this.listViewPanel.add(timePeriodLabel, cc.xy(2,2));

		this.timePeriod = new JComboBox(timePeriods);
		this.listViewPanel.add(timePeriod, cc.xy(4,2));

		this.recentAppointments = new JCheckBox(Translatrix.getTranslationString("Agenda.showRecentAppointments"));
//		this.listViewPanel.add(recentAppointments, cc.xyw(1,3,3));

		addSubPanel(listViewPanel);
		
		buildGridAlphaPanel();
		addSubPanel(this.gridAlphaPanel);
		
		// add max search panel
		this.maxSearchPanel = createSubPanel(Translatrix.getTranslationString("Agenda.settings.maxSearchDaysTitle"));
		this.maxSearchPanel.setLayout(new FormLayout("3dlu, pref:grow, 3dlu, 30dlu, 3dlu", "3dlu, top:pref, 3dlu"));
		this.maxSearchLabel = new JLabel(Translatrix.getTranslationString("Agenda.Agenda.settings.maxSearchDaysText"));
		this.maxSearchPanel.add(maxSearchLabel, cc.xy(2,2));
		this.maxSearchTextField = new JTextField((Integer) getStationary(MAX_SEARCH_DAYS));
		this.maxSearchPanel.add(maxSearchTextField, cc.xy(4,2));
		addSubPanel(maxSearchPanel);
		
		relocalize();
		/* ------------------------------------------------------- */

		setIcon(AgendaModule.getIcon(AgendaModule.ICON_AGENDA));
	}

	public void revertToDefaults() {
		/* ================================================== */

		/* ------------------------------------------------------- */
		this.dayHourStartBox.setDate((Date) getDefault(START_HOUR));
		this.dayHourStopBox.setDate( (Date) getDefault(STOP_HOUR));
		
		this.dayWeekStartBox.setDate((Date) getDefault(WEEK_DAY_START));
		this.dayWeekStopBox.setDate( (Date) getDefault(WEEK_DAY_STOP));
		
		this.dayBreakBox.setDate(DateUtil.createDate(Calendar.HOUR_OF_DAY, (Integer) getDefault(DAY_BREAK)));
		this.startViewBox.setSelectedItem(getDefault(START_VIEW));
		/* ------------------------------------------------------- */
		this.timePeriod.setSelectedItem(getDefault(LIST_VIEW_PERIOD));
		this.recentAppointments.setSelected((Boolean) getDefault(LIST_VIEW_RECENT));
		/* ------------------------------------------------------- */
		this.gridAlphaSlider.setValue((Integer) getDefault(GRID_ALPHA));
		this.maxSearchTextField.setText("" + (Integer) getDefault(MAX_SEARCH_DAYS));
		reflectSettings();
		super.revertToDefaults();
		/* ================================================== */
	}
	

	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#updateSettings()
	 */
	public void updateSettings() {
		/* ================================================== */
		setValue(START_HOUR, this.dayHourStartBox.getDate());
		setValue(STOP_HOUR,  this.dayHourStopBox.getDate());
		
		setValue(WEEK_DAY_START, DateUtil.getDayOfWeek(this.dayWeekStartBox.getDate()));
		setValue(WEEK_DAY_STOP, DateUtil.getDayOfWeek(this.dayWeekStopBox.getDate()));
		
		setValue(DAY_BREAK, DateUtil.getHourOfDay(this.dayBreakBox.getDate()));
		
		setValue(START_VIEW, this.startViewBox.getSelectedItem());
		/* ------------------------------------------------------- */
		setValue(LIST_VIEW_PERIOD, this.timePeriod.getSelectedItem());
		setValue(LIST_VIEW_RECENT, this.recentAppointments.isSelected());
		/* ------------------------------------------------------- */
		setValue(GRID_ALPHA, this.gridAlphaSlider.getValue());
		/* ------------------------------------------------------- */
		setValue(MAX_SEARCH_DAYS, Integer.valueOf(this.maxSearchTextField.getText()));
		super.updateSettings();
		/* ================================================== */
	}

	
	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#reflectSettings()
	 */
	public void reflectSettings() {
		/* ================================================== */
		super.reflectSettings();
		/* ------------------------------------------------------- */
		this.dayHourStartBox.setDate((Date) getValue(START_HOUR));
		this.dayHourStopBox.setDate( (Date) getValue(STOP_HOUR));
		
		this.dayWeekStartBox.setDate(DateUtil.createDate(Calendar.DAY_OF_WEEK, (Integer) getValue(WEEK_DAY_START)));
		this.dayWeekStopBox.setDate(DateUtil.createDate(Calendar.DAY_OF_WEEK, (Integer) getValue(WEEK_DAY_STOP)));
		
		this.dayBreakBox.setDate(DateUtil.createDate(Calendar.HOUR_OF_DAY, (Integer) getValue(DAY_BREAK)));
		/* ------------------------------------------------------- */
		if (getValue(START_VIEW) != null)
			this.startViewBox.setSelectedItem(getValue(START_VIEW));
		else
			this.startViewBox.setSelectedItem(getStationary(START_VIEW));
		/* ------------------------------------------------------- */
		this.timePeriod.setSelectedItem(getValue(LIST_VIEW_PERIOD));
		this.recentAppointments.setSelected((Boolean) getValue(LIST_VIEW_RECENT));
		/* ------------------------------------------------------- */
		// grid alpha
		this.gridAlphaSlider.setValue((Integer) getValue(GRID_ALPHA));
		this.maxSearchTextField.setText("" + (Integer) getValue(MAX_SEARCH_DAYS));
		/* ================================================== */
	}

	
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.settings.SettingsPlugin#relocalize()
	 */
	public void relocalize() {
		/* ================================================== */
		super.relocalize();

		setLabel(Translatrix.getTranslationString("Agenda.Agenda"));
		

		setSubPanelTitle(generalPanel, Translatrix.getTranslationString("Agenda.generalSettings"));
		/* ------------------------------------------------------- */
		dayHoursLabel.setText(Translatrix.getTranslationString("Agenda.settings.hoursPerDay")+":");
		dayHourStartLabel.setText(Translatrix.getTranslationString("Agenda.settings.hoursStart"));
		dayHourStopLabel.setText(Translatrix.getTranslationString("Agenda.settings.hoursStop"));
		/* ------------------------------------------------------- */
		this.dayWeekLabel.setText(Translatrix.getTranslationString("Agenda.settings.daysPerWeek")+":");
		this.dayWeekStartLabel.setText(Translatrix.getTranslationString("Agenda.settings.start"));
		this.dayWeekStopLabel.setText(Translatrix.getTranslationString("Agenda.settings.stop"));
		/* ------------------------------------------------------- */
		this.dayBreakLabel.setText(Translatrix.getTranslationString("Agenda.settings.dayBreak")+":");
		
		
		startViewLabel.setText(Translatrix.getTranslationString("Agenda.settings.startView")+":");
		
		setSubPanelTitle(listViewPanel, Translatrix.getTranslationString("Agenda.listView"));
		timePeriodLabel.setText(Translatrix.getTranslationString("Agenda.listTimePeriods"));
		recentAppointments.setText(Translatrix.getTranslationString("Agenda.showRecentAppointments"));
		
		setSubPanelTitle(this.gridAlphaPanel, Translatrix.getTranslationString("Agenda.settings.gridAlpha"));
		this.gridAlpaLabel.setText("<html>"+Translatrix.getTranslationString("Agenda.settings.gridAlphaExplanation"));
		
		setSubPanelTitle(this.maxSearchPanel, Translatrix.getTranslationString("Agenda.settings.maxSearchDaysTitle"));
		this.maxSearchLabel.setText(Translatrix.getTranslationString("Agenda.settings.maxSearchDaysText"));
		/* ================================================== */
	}

	/**
	 * 
	 */
	public void setStationaryValues() {
		/* ================================================== */
		setStationary(START_HOUR, DateUtil.createDate(Calendar.HOUR_OF_DAY, 8));
		setStationary(STOP_HOUR,  DateUtil.createDate(Calendar.HOUR_OF_DAY, 18));

		setStationary(WEEK_DAY_START, Calendar.MONDAY);
		setStationary(WEEK_DAY_STOP, Calendar.FRIDAY);
		
		setStationary(DAY_BREAK, 12);
		setStationary(LIST_VIEW_PERIOD, DayViewPanel.VIEW_NAME_WEEK);
		/* ------------------------------------------------------- */
		setStationary(LIST_VIEW_PERIOD, 7);
		setStationary(LIST_VIEW_RECENT, false);
		/* ------------------------------------------------------- */
		setStationary(START_VIEW, DayViewPanel.VIEW_NAME_WEEK);
		// grid alpha
		setStationary(GRID_ALPHA, 50);
		// LayOut
		setStationary(VIEW_LAYOUT, true);
		/* ------------------------------------------------------- */
		setStationary(MAX_SEARCH_DAYS, 10);
		/* ================================================== */
	}

	
	
	private void buildGridAlphaPanel () {
		/* ================================================== */
		this.gridAlphaPanel = createSubPanel(Translatrix.getTranslationString("Agenda.settings.gridAlpha"));
		/* ------------------------------------------------------- */
		this.gridAlphaPanel.setLayout(new FormLayout("3dlu, 70dlu, 5dlu, fill:pref:grow, 3dlu",
													 "3dlu, top:pref, 3dlu"));
		this.gridAlpaLabel = new JLabel();
		this.gridAlphaPanel.add(this.gridAlpaLabel, cc.xy(2, 2));
		/* ------------------------------------------------------- */
		// create the slider
		this.gridAlphaSlider = new JSlider(0, 255,	50);
//		this.gridAlphaSlider.setPaintTicks(true);
//		this.gridAlphaSlider.setPaintLabels(true);
//		this.gridAlphaSlider.setPaintTrack(true);
		this.gridAlphaSlider.setPaintTicks( true ); 
		this.gridAlphaSlider.setMinorTickSpacing(20);
		/* ------------------------------------------------------- */
		this.gridAlphaSlider.addMouseWheelListener(new MouseWheelListener() {

			public void mouseWheelMoved(MouseWheelEvent e) {
				/* ====================================================== */
				gridAlphaSlider.setValue(gridAlphaSlider.getValue() + e.getWheelRotation() * 6);
				/* ====================================================== */
			}
		});
		
		
		
		/* ------------------------------------------------------- */
		this.gridAlphaPanel.add(this.gridAlphaSlider, cc.xy(4, 2));
		/* ------------------------------------------------------- */
		/* ================================================== */
	}
	
	
	/**
	 * Creates the day/week view settings panel
	 */
	private void buildGeneralDayViewPanel() {
		/* ================================================== */
		// day hours panel
		JPanel dayHourPanel = new JPanel(new FormLayout(
				// cols
				"3dlu, fill:pref:grow, 5dlu, fill:pref:grow, 3dlu",
				// rows
				"3dlu, fill:pref, 4dlu, fill:pref, 3dlu, fill:pref, 3dlu"));
		/* ------------------------------------------------------- */
		this.dayHoursLabel  	= new JLabel();
		this.dayHourStartLabel  = new JLabel();
		this.dayHourStopLabel 	= new JLabel();
		/* ------------------------------------------------------- */
		// create an Array for the hour boxes
		Integer[] hours = new Integer[24];
		for (int i = 0; i < 24; i++) {
			hours[i] = i;
		}
		/* ------------------------------------------------------- */
		this.dayHourStartBox = new DateTimeChooser("", DateTimeChooser.HOUR_BOX);
		this.dayHourStopBox  = new DateTimeChooser("", DateTimeChooser.HOUR_BOX);
		/* ------------------------------------------------------- */
		dayHourPanel.add(dayHoursLabel,        cc.xyw(2, 2, 3));
		dayHourPanel.add(dayHourStartLabel,    cc.xy(2, 4));
		dayHourPanel.add(dayHourStopLabel,     cc.xy(4, 4));
		/* ------------------------------------------------------- */
		dayHourPanel.add(this.dayHourStartBox, cc.xy(2, 6));
		dayHourPanel.add(this.dayHourStopBox,  cc.xy(4, 6));
		/* ------------------------------------------------------- */
		
		// ======================================================================
		// Days per week panel
		// ======================================================================
		JPanel daysPerWeekPanel = new JPanel(new FormLayout(
				// cols
				"3dlu, fill:pref:grow, 5dlu, fill:pref:grow, 3dlu",
				// rows
				"3dlu, fill:pref, 4dlu, fill:pref, 3dlu, fill:pref, 3dlu"));
		/* ------------------------------------------------------- */
		this.dayWeekLabel = new JLabel();
		this.dayWeekStartLabel = new JLabel();
		this.dayWeekStopLabel = new JLabel();
		
		
		this.dayWeekStartBox = new DateTimeChooser("", DateTimeChooser.DAY_BOX);
		this.dayWeekStopBox  = new DateTimeChooser("", DateTimeChooser.DAY_BOX);
		/* ------------------------------------------------------- */
		daysPerWeekPanel.add(dayWeekLabel, 		cc.xy(2, 2));
		daysPerWeekPanel.add(dayWeekStartLabel, cc.xy(2, 4));
		daysPerWeekPanel.add(dayWeekStopLabel,  cc.xy(4, 4));
		/* ------------------------------------------------------- */
		daysPerWeekPanel.add(dayWeekStartBox,	cc.xy(2, 6));
		daysPerWeekPanel.add(dayWeekStopBox, 	cc.xy(4, 6));
		/* ------------------------------------------------------- */
		
		// ======================================================================
		// Day break panel
		// ======================================================================
		
		JPanel dayBreakPanel = new JPanel(new FormLayout(
				// cols
				"3dlu, fill:pref:grow,3dlu",
				// rows
				"3dlu, fill:pref, 3dlu, fill:pref,3dlu"));
		/* ------------------------------------------------------- */
		this.dayBreakLabel = new JLabel();
		/* ------------------------------------------------------- */
		this.dayBreakBox = new DateTimeChooser("", DateTimeChooser.HOUR_BOX);
//		// set default to 12 o'clock
//		Calendar cal = Calendar.getInstance();
//		
//		cal.set(Calendar.HOUR_OF_DAY, 12);
//		cal.set(Calendar.MINUTE, 1);
//		this.dayBreakBox.setDate(cal.getTime());
		/* ------------------------------------------------------- */
		dayBreakPanel.add(dayBreakLabel, cc.xy(2 ,2));
		dayBreakPanel.add(dayBreakBox,   cc.xy (2, 4));
		/* ------------------------------------------------------- */
		
		
		// ======================================================================
		// Start view select panel
		// ======================================================================
		JPanel viewSelectPanel = new JPanel(new FormLayout(
				// cols
				"3dlu, fill:pref:grow,3dlu",
				// rows
				"3dlu, fill:pref, 3dlu, fill:pref,3dlu"));
		/* ------------------------------------------------------- */
		String[] views = {
				DayViewPanel.VIEW_NAME_DAY,
				DayViewPanel.VIEW_NAME_WEEK,
				MonthViewPanel.VIEW_NAME,
				ListViewPanel.VIEW_NAME
				};
		
		this.startViewLabel = new JLabel();
		this.startViewBox = new JComboBox(views);
		this.startViewBox.setRenderer(new DefaultListCellRenderer() {
			private static final long serialVersionUID = 1L;
			@Override
			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				return super.getListCellRendererComponent(
						list, 
						Translatrix.getTranslationString("bizcal." + (String) value), 
						index, 
						isSelected,
						cellHasFocus);
			}
		});
		viewSelectPanel.add(this.startViewLabel, 	cc.xy(2, 2));
		viewSelectPanel.add(this.startViewBox, 		cc.xy(2, 4));
		// ====================================================================
		// the settings sub panel
		
		this.generalPanel = createSubPanel(Translatrix.getTranslationString("Agenda.generalSettings"));
		this.generalPanel.setLayout(new FormLayout(
				// cols
				"1dlu, fill:pref:grow,center:5dlu, fill:pref:grow,1dlu",
				//rows
				"1dlu, fill:pref:grow,center:5dlu, fill:pref:grow,1dlu"));
		/* ------------------------------------------------------- */
//		dayHourPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
//		daysPerWeekPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
//		dayBreakPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
//		viewSelectPanel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
		
		
		
		this.generalPanel.add(dayHourPanel, 	cc.xy(2, 2));
		this.generalPanel.add(daysPerWeekPanel, cc.xy(4, 2));
		this.generalPanel.add(dayBreakPanel, 	cc.xy(2, 4));
		this.generalPanel.add(viewSelectPanel,  cc.xy(4, 4));

		this.generalPanel.add(new JSeparator(SwingConstants.HORIZONTAL), cc.xy(2, 3));
		this.generalPanel.add(new JSeparator(SwingConstants.HORIZONTAL), cc.xy(4, 3));
		this.generalPanel.add(new JSeparator(SwingConstants.VERTICAL),   cc.xy(3, 2));
		this.generalPanel.add(new JSeparator(SwingConstants.VERTICAL),   cc.xy(3, 4));
		
		/* ================================================== */
	}
	
	
	/**
	 * Set and save a value of the setting
	 * @param key of the setting
	 * @param value of the setting
	 */
	public void setValueAndSave(String key, Object value)
	{
		setValue(key, (Boolean) value);
		MainFrame.getInstance().saveSettings();
	}
	
}


