/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: FutureAppointmentEventListCellRenderer.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:01  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.2  2007/08/29 05:35:58  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/08/28 11:34:36  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import bizcal.common.Event;

/**
 * Cellrenderer for events that are displayed in the fadin popup appearing
 * on the appointment modify dialog. Shows appointments in the future.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 28.08.2007
 * 11:16:54
 *
 *
 * @version
 * <br>$Log: FutureAppointmentEventListCellRenderer.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:01  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.2  2007/08/29 05:35:58  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/08/28 11:34:36  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class FutureAppointmentEventListCellRenderer extends DefaultListCellRenderer {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private FutureEventListFrameArea area;
	
	
	
	public FutureAppointmentEventListCellRenderer() {
		/* ================================================== */
		this.area = new FutureEventListFrameArea();
		area.setPreferredSize(new Dimension(100, 60));
		/* ================================================== */
	}
	

	/* (non-Javadoc)
	 * @see javax.swing.DefaultListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
		/* ====================================================== */
		if (value instanceof Event){
			this.area.setEvent((Event) value);
			
			
			Color l_Background;

			l_Background = (index % 2 == 0) ? GECAMedColors.c_OddLineBackground
												: GECAMedColors.c_EvenLineBackground;
			if (!isSelected)
				area.setBgColor(l_Background);
			else
				area.setBgColor(GECAMedColors.c_GECAMedDarkerBackground);
			return this.area;
		} else
			return super.getListCellRendererComponent(list, value, index, isSelected,
				cellHasFocus);
		/* ====================================================== */
	}
	
	
	
	

}
