/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

import javax.swing.JComponent;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import bizcal.common.Event;

/**
 * Component used by the FutureAppointmentEventListCellRenderer to display appointments.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.07.2007
 * 10:06:58
 *
 *
 * @version
 * <br>$Log: FutureEventListFrameArea.java,v $
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-08-19 10:25:08  heinemann
 * <br>cleanup
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.2  2007/08/29 05:35:58  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class FutureEventListFrameArea extends JComponent {
	
	private static final long serialVersionUID = 1L;


	private boolean selected;

	private Color bgColor = Color.WHITE;

	public double xPosition = 0.0;

	public double yPosition = 54.0;

	private Font normalFont;

	private float ALPHA_DEFAULT = 0.2f;

	private float alphaValue = ALPHA_DEFAULT;

	
	
	public final DateFormat timeFormat = new SimpleDateFormat("HH:mm",
			Locale.getDefault());
	public final DateFormat dayFormat = new SimpleDateFormat("EEEE",
			Locale.getDefault());
	public final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy",
			Locale.getDefault());
	
	
	private Font dayFont  = new Font("Arial", Font.BOLD, 12);
	private Font rangeFont = new Font("Arial", Font.BOLD, 10);

	private Event event;
	

	/**
	 * @throws Exception
	 */
	public FutureEventListFrameArea() {
		/* ================================================== */
		this.normalFont = new Font("Verdana", Font.PLAIN, 10);
		this.setFont(normalFont);
		// change color for drag
		this.setBackground(new Color(100, 100, 245));
		this.setForeground(Color.BLACK);
		/* ================================================== */
	}

	/**
	 * @param event
	 */
	public void setEvent(Event event) {
		/* ================================================== */
		this.event = event;
		/* ================================================== */
	}
	
	/**
	 * @param aValue
	 */
//	@Deprecated
	public void setAlphaValue(float aValue) {
		if (aValue > 1.0f)
			aValue = 1.0f;
//		this.alphaValue = aValue - SELECT_OFFSET;
	}

	/**
	 * @return
	 */
	public float getAlphaValue() {
		return this.alphaValue;
	}

	// The toolkit will invoke this method when it's time to paint
	public void paint(Graphics g) {
		/* ================================================== */
		try {
			setBackground(this.bgColor);
		} catch (Exception e) {
		}
		/* ------------------------------------------------------- */
		Graphics2D g2 = (Graphics2D) g;
		// makes the graphics smoother
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		/* ------------------------------------------------------- */
		int width = (int) getWidth();
		int height = (int) getHeight();
		BufferedImage buffImg = null;
		try {
			/* ------------------------------------------------------- */
			buffImg = new BufferedImage(width, height,
						  				BufferedImage.TYPE_INT_ARGB);
			/* ------------------------------------------------------- */
		} catch (Exception e) {
			e.printStackTrace();
		}
		/* ------------------------------------------------------- */
		Graphics2D gbi = buffImg.createGraphics();
		gbi.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
									RenderingHints.VALUE_ANTIALIAS_ON);
		gbi.setStroke(new BasicStroke(1.0f));
		
		
		// ============================================================
		// draw non-round rectangle
		// ============================================================
		/* ------------------------------------------------------- */
//		AlphaComposite ac = null;
//		ac = AlphaComposite.getInstance(AlphaComposite.DST_OVER, alphaValue);
////		gbi.setComposite(ac);
		gbi.setPaint(this.getBackground());
//		/* ------------------------------------------------------- */
		gbi.fill(new Rectangle2D.Double(0, 0, width, height));
//		/* ------------------------------------------------------- */
//		gbi.setPaint(Color.lightGray);
//		gbi.draw(new Rectangle2D.Double(1, 1, width - 2, height - 2));
//
//		/* ------------------------------------------------------- */
//		
		g2.drawImage(buffImg, null, 0, 0);
		/* ------------------------------------------------------- */
		// =============================================================
		// draw icon
		// =============================================================
		int xpos = 5;
		int ypos = 5;
		if (event.getIcon() != null) {
//			g2.drawImage(icon.getImage(), xpos, ypos, this);
			g2.drawImage(event.getIcon().getImage(), xpos, ypos, this);
			xpos += event.getIcon().getIconWidth() + 3;
		}

		// =================================================================================
		// actions below this point will be placed on top of the "colored glass"
		//
		// =================================================================================

		
		// ============================================================
		// paint the main view
		//
		// ============================================================
		if (this.event != null) {
			/* ------------------------------------------------------- */
			
			/* ------------------------------------------------------- */
			g2.setColor(Color.BLACK);
			g2.setFont(dayFont);
			g2.drawString(dayFormat.format(event.getStart()), xpos+10, ypos+13);
			g2.drawString(dateFormat.format(event.getStart()), 5, ypos+20+dayFont.getSize2D());
			/* ------------------------------------------------------- */
			g2.setFont(rangeFont);
			// time
			g2.drawString(timeFormat.format(event.getStart()) +" - " +
					timeFormat.format(event.getEnd()), xpos+12, ypos+25+(2*dayFont.getSize2D()));
			/* ------------------------------------------------------- */
			// draw a rectangle for the color
			if (event.getColor() != null) {
				/* ------------------------------------------------------- */
				int rectWidth = 20;
				g2.setColor(event.getColor());
				/* ------------------------------------------------------- */
//				AlphaComposite ac = AlphaComposite.getInstance(
//						AlphaComposite.DST_OVER, alphaValue);
//				gbi.setComposite(ac);
				/* ------------------------------------------------------- */
				g2.fillRect(getWidth()-rectWidth-5, ypos, rectWidth, getHeight()-ypos-5);
				g2.setColor(Color.BLACK);
				/* ------------------------------------------------------- */
				
				g2.drawRect(getWidth()-rectWidth-5, ypos, rectWidth, getHeight()-ypos-5);
				/* ------------------------------------------------------- */
			}
			/* ------------------------------------------------------- */
		}
		
		super.paint(g2);
		super.paint(gbi);
		/* ================================================== */
	}



	public void setSelected(boolean flag) {
		this.selected = flag;
		this.setBrightness(flag);
//		repaint();
	}

	public boolean isSelected() {
		return this.selected;
	}

	/**
	 * Switches the brightnes of a frame area
	 * to bright or darker
	 *
	 * true - brighter
	 * false - darker
	 * @param b
	 */
	public void setBrightness(boolean b) {
		/* ================================================== */
		if (b) {
//			this.alphaValue = ALPHA_DEFAULT + SELECT_OFFSET;
			setBgColor(GECAMedColors.c_GECAMedDarkerBackground);
		}
		else {
//			this.alphaValue = ALPHA_DEFAULT - SELECT_OFFSET;
			setBgColor(Color.WHITE);
		}
		/* ================================================== */
	}
	
	
	public void setBgColor(Color color) {
		this.bgColor = color;
//		repaint();
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.JComponent#isOptimizedDrawingEnabled()
	 */
	@Override
	public boolean isOptimizedDrawingEnabled() {
		/* ====================================================== */
		return false;
		/* ====================================================== */
	}
}
