/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;


/**
 * Dialog to modify the recurrence Options of an appointment.
 */

/**
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: RecurrenceOptionDialog.java,v $
 * <br>Revision 1.7  2013-12-27 18:08:18  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2011-06-16 15:13:14  troth
 * <br>fix Ticket #863 Dialog 'Wiederholungsoption' beh�lt alte Werte zur�ck
 * <br><http://santec.tudor.lu/trac/gecamed/ticket/863>
 * <br>
 * <br>Revision 1.5  2011-05-12 12:49:14  troth
 * <br>Fix little Bug - Dialog was not reset to init values when create a new appointment.
 * <br>
 * <br>Revision 1.4  2011-05-11 15:07:08  troth
 * <br>fix followup bug of Ticket  839 http://santec.tudor.lu/trac/gecamed/ticket/839
 * <br>
 * <br>Revision 1.3  2011-05-10 16:50:52  troth
 * <br>code clean up
 * <br>
 * <br>Revision 1.2  2011-05-09 14:30:20  troth
 * <br>Fix Ticket 839: "End after [X] occurrences" not taken into account
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/839
 * <br>
 * <br>Revision 1.1  2011-04-04 11:38:31  troth
 * <br>Redesign of the appointment create dialog and the right navi bar.
 * <br>
 */
public class RecurrenceOptionDialog extends JDialog {

	/**
	 * 
	 */
	private static final long 				serialVersionUID = 1L;
	
	private static RecurrenceOptionDialog 	instance = new RecurrenceOptionDialog();

	private AbstractAction 					cancelAction;

	private AbstractAction 					okAction;
	
	private JButton 						cancelButton;
	
	private JButton 						okButton;
	
	private Appointment 					appointment;
	
	private RecurrencePanel 				recurrencePanel;
	
	public boolean							wasOpen;
	
	
	private RecurrenceOptionDialog() {
		// ==================================================
		super(MainFrame.getInstance(),
				Translatrix.getTranslationString("calendar.recurrence.dialogTitle"),
				true);
		
		this.recurrencePanel = new RecurrencePanel();
		this.recurrencePanel.setOpaque(true);
		this.recurrencePanel.setBackground(GECAMedColors.c_GECAMedBackground);
		this.add(this.recurrencePanel);
				
		initButtonPanel();
		initButtonActions();
		// ==================================================
		this.addWindowListener(new WindowAdapter() {

			@Override
			public void windowClosing(WindowEvent e) {
				//appointment = null;
				instance.setVisible(false);
				wasOpen = false;
			}
		});
		// ==================================================
	}
	
	/**
	 * Get the instance of the RecurrenceOptionDialog
	 * 
	 * @return the instance of the RecurrenceOptionDialog
	 */
	public static RecurrenceOptionDialog getInstance() {
		if (instance == null)
			instance = new RecurrenceOptionDialog();
		
		return instance;
	}
	
	/**
	 * Get the current appointment
	 * 
	 * @return the appointment
	 */
	public Appointment getAppointment() {
		/* ================================================== */
		return this.appointment;
		/* ================================================== */
	}
	
	public void getAppointment(Appointment appointment) {
		/* ================================================== */
		this.recurrencePanel.getAppointment(appointment);
		/* ================================================== */
	}

	
	/**
	 * @param appointment
	 */
	public void showDialog(Appointment appointment) {
		/* ================================================== */
		if(appointment.getFrequency() == Appointment.NO_RECUR)
			this.recurrencePanel.initRecurrencePanel(false);
		
		this.appointment = appointment.copy();
		this.recurrencePanel.resetPanel();
		this.recurrencePanel.setAppointment(this.appointment);
		/* ================================================== */
		this.pack();
		this.wasOpen = true;
		MainFrame.showDialogCentered(instance);
		/* ================================================== */
	}
	
	
	// **********************************************************************
	// Init stuff
	// **********************************************************************
	
	/**
	 * 
	 */
	private void initButtonPanel() {
		// ==========================================================
		// button panel
		// ==========================================================
		this.okButton 		= new JButton();
		this.cancelButton 	= new JButton();
		ButtonBarBuilder bb = new ButtonBarBuilder();
		/* ------------------------------------------------------- */
		bb.addGlue();
		bb.addGridded(okButton);
		bb.addRelatedGap();
		bb.addGridded(cancelButton);
		/* ------------------------------------------------------- */
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// a panel to make a gap between the dialog border and the buttons
		JPanel gapPanel = new JPanel(new BorderLayout(5,5));
		gapPanel.setOpaque(true);
		gapPanel.setBackground(Color.WHITE);
		gapPanel.add(bb.getPanel(), BorderLayout.CENTER);
		gapPanel.add(new JLabel(""), BorderLayout.SOUTH);
		gapPanel.add(new JLabel(""), BorderLayout.EAST);
		gapPanel.add(new JLabel(""), BorderLayout.NORTH);
		/* ------------------------------------------------------- */
//		gapPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
		/* ------------------------------------------------------- */

		this.add(gapPanel, BorderLayout.SOUTH);
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	private void initButtonActions() {
		/* ================================================== */
		this.cancelAction = new AbstractAction(Translatrix.getTranslationString("calendar.core.cancel"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				//appointment = null;
				instance.setVisible(false);
				wasOpen = false;
				/* ====================================================== */
			}
		};
		/* ------------------------------------------------------- */
		this.okAction = new AbstractAction(Translatrix.getTranslationString("calendar.core.ok"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.OK)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				fillAppointment();

				instance.setVisible(false);
				/* ====================================================== */
			}
		};
		/* ------------------------------------------------------- */
		this.okButton.setAction(okAction);
		this.cancelButton.setAction(cancelAction);
		// =================================================================


		// =================================================================
		// define dialog wide key mappings
		// =================================================================
		KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEsc, "continue");
		((JPanel) this.getContentPane()).getActionMap().put("continue", cancelAction);
		/* ================================================== */
	}
	
	/**
	 * Fills the appointment with the data from the form fields
	 */
	private void fillAppointment() {
		/* ================================================== */
		if (this.appointment == null)
			this.appointment = new Appointment();
		/* ------------------------------------------------------- */
		
		this.recurrencePanel.getAppointment(this.appointment);
		/* ================================================== */
	}
	
	public void setAppointment(Appointment appointment)
	{
		this.appointment = appointment;
	}
	
	public void setRecurrencePanel(RecurrencePanel recurrencePanel)
	{
		this.recurrencePanel = recurrencePanel;
	}
	
	public RecurrencePanel getRecurrencePanel()
	{
		return this.recurrencePanel;
	}
	
}