/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype;

import java.awt.Component;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.core.gui.widgets.NumberField;

/**
 * CellEditor to change the duration of an AppointmentType
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:22:56
 *
 *
 * @version
 * <br>$Log: AppointmentTypeTableCellDurationEditor.java,v $
 * <br>Revision 1.5  2010-06-30 09:45:42  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2009-03-10 09:51:42  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class AppointmentTypeTableCellDurationEditor extends AbstractCellEditor
		implements TableCellEditor {

	private static final long serialVersionUID = 1L;

	private NumberField component;

	public AppointmentTypeTableCellDurationEditor() {
//		SpinnerNumberModel nm = new SpinnerNumberModel(15, 0, 200, 1);
		component = new NumberField(3);
	}

	public Component getTableCellEditorComponent(JTable table, Object value,
			boolean isSelected, int row, int column) {
		if (value == null)
			value = 0;
		component.setText(value+"");
		return component;
	}

	public Object getCellEditorValue() {
	    try {
		return Integer.parseInt(component.getText());
	    } catch (Exception e) {
		return 0;
	    }
	}

}
