/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.agenda.gui.AgendaModule;

/**
 * Celleditor to modify the icons for AppointmentTypes
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:23:31
 *
 *
 * @version
 * <br>$Log: AppointmentTypeTableCellIconEditor.java,v $
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class AppointmentTypeTableCellIconEditor extends AbstractCellEditor implements TableCellEditor, ActionListener {

			private static final long serialVersionUID = 1L;
			
			private JComboBox component;
			
			public AppointmentTypeTableCellIconEditor() {
				super();
				component = new JComboBox(AgendaModule.TYPE_ICONS);
				component.setRenderer(new DefaultListCellRenderer() {
					private static final long serialVersionUID = 1L;

					public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
						JLabel jl =  (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
						jl.setIcon(AgendaModule.getMiniIcon((String) value));
						jl.setText(null);
						return jl;
					}
				});
				
				component.addActionListener(this);
			}

	        public Component getTableCellEditorComponent(JTable table, Object value,
	                boolean isSelected, int rowIndex, int vColIndex) {
	            ((JComboBox)component).setSelectedItem((String)value);
	            return component;
	        }

	        public Object getCellEditorValue() {
	            return ((JComboBox)component).getSelectedItem();
	        }

			public void actionPerformed(ActionEvent e) {
				fireEditingStopped();
			}
			
		}
