/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.agenda.gui.AgendaModule;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;


/**
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:24:09
 *
 *
 * @version
 * <br>$Log: AppointmentTypeTableCellRenderer.java,v $
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class AppointmentTypeTableCellRenderer extends LineColorCellRenderer {
	
		private static final long serialVersionUID = 1L;

		@Override
		public Component getTableCellRendererComponent(JTable p_Table, Object value, boolean p_IsSelected, boolean hasFocus, int p_Row, int p_Column) {

			JLabel jl =  (JLabel) super.getTableCellRendererComponent(p_Table, value, p_IsSelected,
					hasFocus, p_Row, p_Column);
			
			if (p_Column == 0)
				jl.setHorizontalAlignment(JLabel.LEFT);
			else 
				jl.setHorizontalAlignment(JLabel.CENTER);

			if (p_Column == 2) {
				jl.setIcon(AgendaModule.getMiniIcon((String) value));
				jl.setText(null);
			} else {
				jl.setIcon(null);
			}
			
			return jl;
		}
	}
