/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.AppointmentType;
import lu.tudor.santec.gecamed.agenda.ejb.session.beans.AppointmentManagerBean;
import lu.tudor.santec.gecamed.agenda.ejb.session.interfaces.AppointmentManager;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;


/**
 * Table model for AppointmentTypes.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:13:35
 *
 *
 * @version
 * <br>$Log: AppointmentTypesTableModel.java,v $
 * <br>Revision 1.8  2013-12-27 18:09:27  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.7  2013-07-15 06:18:39  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.6  2012-04-24 14:02:13  troth
 * <br>Remove same warnings.
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class AppointmentTypesTableModel extends AbstractTableModel {
		
		private static final long serialVersionUID = 1L;
		private static final String MODEL_CHANGED = "MODEL_CHANGED";
		private Vector<AppointmentType> v;
		
		private AppointmentManager apManager;
		
		/**
		 * static logger for this class
		 */
		private static Logger  logger = Logger.getLogger(AppointmentTypesTableModel.class.getName());

		private final String[] columnNames = {
												Translatrix.getTranslationString("calendar.core.name"),
												Translatrix.getTranslationString("calendar.duration"),
												Translatrix.getTranslationString("calendar.icon")
											};
		
		private final Class<?>[] columnClasses = {	String.class,
												Integer.class,
												String.class
											};
		private boolean instantSave;
		private Vector<PropertyChangeListener> listeners = new Vector<PropertyChangeListener>();
		
		/**
		 * @param at
		 * @param instantSave
		 */
		public AppointmentTypesTableModel(Collection<AppointmentType> at, boolean instantSave) {
			
			this.instantSave = instantSave;
			
			try {
				apManager = (AppointmentManager) ManagerFactory
				.getRemote(AppointmentManagerBean.class);
			} catch (Exception e) {
				logger.log(Level.WARN, "error getting APPOINTMENTMANAGER" , e);
			}
			
			setTypes(at);
		}
		
		/**
		 * @param at
		 */
		public void setTypes(Collection<AppointmentType> at) {
			if (at == null)
				v = new Vector<AppointmentType>();
			else
				v = new Vector<AppointmentType>(at);
			fireTableDataChanged();
			fireEvent();
		}

		/**
		 * @param at
		 */
		public void addElement(AppointmentType at) {
			v.add(at);
			fireTableDataChanged();
			fireEvent();
		}

		@Override
		public String getColumnName(int column) {
			return columnNames[column];
		}
		
		@Override
		public Class<?> getColumnClass(int column) {
			return columnClasses[column];
		}

		public int getColumnCount() {
			return 3;
		}

		public int getRowCount() {
			return v.size();
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			
			if (rowIndex < 0) {
				return null;
			}
			
			AppointmentType t = v.get(rowIndex);
			
			switch (columnIndex) {
			case 0:
				return t.getName();
			case 1:
				return t.getDuration();
			case 2:
				return t.getIcon();
			default:
				return null;
			}
		}


		@Override
		public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
			if (rowIndex < 0) {
				return;
			}
			try {
				AppointmentType t = v.get(rowIndex);
				switch (columnIndex) {
				case 0:
					t.setName((String) aValue);
					break;
				case 1:
					if (aValue == null)
						aValue = 0;
					t.setDuration((Integer) aValue);
					break;
				case 2:
					t.setIcon((String) aValue);
					break;
				default:
					return;
				}
				if (instantSave) {
					t = apManager.saveAppointmentType(MainFrame.getClientId(), t);
					v.set(rowIndex, t);
				}
				fireTableDataChanged();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		

		@Override
		public boolean isCellEditable(int rowIndex, int columnIndex) {
			return true;
		}
		
		public AppointmentType getElement(int row) {
			try {
				return v.get(row);				
			} catch (Exception e) {
				return null;
			}
		}
		
		public void deleteElement(AppointmentType at ) {
			try {
				v.remove(at);
				fireTableDataChanged();
			} catch (Exception e) {
			}
			fireEvent();
		}

		public Collection<AppointmentType> getElements() {
			return v;
		}
		
		public void addPropertyChangeListener(PropertyChangeListener listener) {
			listeners .add(listener);
		}
		
		public void removePropertyChangeListener(PropertyChangeListener listener) {
			listeners.remove(listener);
		}
		
		private void fireEvent() {
			for (Iterator<PropertyChangeListener> iter = listeners.iterator(); iter.hasNext();) {
				PropertyChangeListener listener = (PropertyChangeListener) iter.next();
				listener.propertyChange(new PropertyChangeEvent(this,MODEL_CHANGED, getRowCount(), getRowCount()));
				
			}
		}
		
	}
