/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import lu.tudor.santec.gecamed.agenda.utils.RRule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * Abstract class for components that can modify the recurrency of an appointment.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:25:53
 *
 *
 * @version
 * <br>$Log: AbstractFrequencePanel.java,v $
 * <br>Revision 1.8  2012-06-28 15:32:31  troth
 * <br>Move the java class RRule from the package 'lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence' to 'lu.tudor.santec.gecamed.agenda.utils' because the class is need in the agenda beans.
 * <br>
 * <br>Revision 1.7  2011-08-04 08:59:11  troth
 * <br>fix some warnings.
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public abstract class AbstractFrequencePanel extends JPanel {
	
	private static final long serialVersionUID = 1L;
	private JPanel recPanel;
	protected JSpinner spinner;
	protected JLabel unitLabel;
	protected CellConstraints cc = new CellConstraints();

	/**
	 * @param unit
	 */
	public AbstractFrequencePanel(String unit) {
		this.setLayout(new BorderLayout());
		this.setOpaque(false);
		this.recPanel = new JPanel();
		this.recPanel.setOpaque(false);
		this.recPanel.setLayout(new FormLayout(
				"pref, 2dlu, 20dlu, 2dlu, pref:grow",
				"pref"));
		
		this.recPanel.add(new JLabel(Translatrix.getTranslationString("calendar.recurrence.recurEvery")), cc.xy(1,1));
		this.spinner = new JSpinner(new SpinnerNumberModel(1,1,10,1));
		this.spinner.setValue(1);
		this.recPanel.add(spinner, cc.xy(3, 1));
		this.unitLabel = new JLabel(unit);
		this.recPanel.add(unitLabel, cc.xy(5, 1));
		this.add(recPanel, BorderLayout.NORTH);
	}
	

	public abstract void setRule(RRule rule);
	
	public abstract void getRule(RRule rule);
	
	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		Component[] components = getComponents();
		if (components != null && components.length > 0) {
			int count = components.length;
			for (int i = 0; i < count; i++)
				components[i].setEnabled(enabled);
		}
		
		components = recPanel.getComponents();
		if (components != null && components.length > 0) {
			int count = components.length;
			for (int i = 0; i < count; i++)
				components[i].setEnabled(enabled);
		}

	}
	
	public Integer getRecurrsEvery() {
		return (Integer) this.spinner.getValue();
	}
	
}
