/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;
import lu.tudor.santec.gecamed.agenda.utils.RRule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Modificaftion panel for events that should recurr yearly.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:41:24
 *
 *
 * @version
 * <br>$Log: YearlyFreqPanel.java,v $
 * <br>Revision 1.6  2012-06-28 15:32:30  troth
 * <br>Move the java class RRule from the package 'lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence' to 'lu.tudor.santec.gecamed.agenda.utils' because the class is need in the agenda beans.
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class YearlyFreqPanel extends AbstractFrequencePanel {

	private static final long serialVersionUID = 1L;
	
	public YearlyFreqPanel() {
		super(Translatrix.getTranslationString("calendar.recurrence.recurYears"));
	}
	
	@Override
	public void getRule(RRule rule) {
		rule.putElement(Appointment.INTERVAL, spinner.getValue() + "");
	}

	@Override 
	public void setRule(RRule rule) {
		try {
			this.spinner.setValue(rule.getInterval());
		} catch (Exception e) {
			this.spinner.setValue(1);
		}
	}

}
